/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef REQUESTLOGWINDOW_H_
#define REQUESTLOGWINDOW_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "RequestLogIcons.h"
#include <ace/config-lite.h>
#include <wx/frame.h>

class wxCloseEvent;
class wxCommandEvent;
class wxPanel;
class wxBoxSizer;
class wxListCtrl;
class wxToggleButton;

namespace wxGUI
{

class RequestLogWindow : public wxFrame
{
public:
	RequestLogWindow();
	
	virtual ~RequestLogWindow();
	
	static void show();
private:
	class LogView;

	void onWindowClose(wxCloseEvent& evt);
	
	void onClose(wxCommandEvent& evt);

	void onClear(wxCommandEvent& evt);
	
	void onLegend(wxCommandEvent& evt);

	void showLog();

	void showLegend();

	static RequestLogWindow* m_spInstance;
	RequestLogIcons m_icons;
	wxPanel* m_pTopPanel;
	wxBoxSizer* m_pLogSizer;
	LogView* m_pLogView;
	wxListCtrl* m_pLegendView;
	wxToggleButton* m_pLegendButton;
	DECLARE_EVENT_TABLE()
};

} // namespace wxGUI

#endif
