/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef WXGUI_FORWARDINGCONFIGFILE_H_
#define WXGUI_FORWARDINGCONFIGFILE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include "Forwarding.h"
#include <ace/config-lite.h>
#include <wx/filename.h>

class ObsoleteForwardingInfo;

namespace wxGUI
{

/**
 * \brief Provides high-level load-apply-save operations on "forwarding.xml" file.
 */
class ForwardingConfigFile
{
	// can be easily made copyable if necessary
	DECLARE_NON_COPYABLE(ForwardingConfigFile)
public:
	ForwardingConfigFile(wxFileName const& file_path);
	
	~ForwardingConfigFile();
	
	/**
	 * \brief Loads file from disk, parses and applies it.
	 *
	 * Returns true on success and false on failure.  Note that success
	 * doesn't imply the absence of errors or warnings.  Only serious
	 * errors will cause failure.  Progress and errors / warnings will be
	 * reported through OperationLog.
	 * In case "forwarding.xml" file doesn't exist or doesn't contain
	 * any forwarding options, \p fallback is applied.  In this case,
	 * true is returned.
	 */
	bool loadAndApply(ObsoleteForwardingInfo const& fallback);
	
	/**
	 * \brief Parses, applies and saves the new file.
	 *
	 * Returns true on success and false on failure.  Note that success
	 * doesn't imply the absence of errors or warnings.  Only serious
	 * errors will cause failure.  Progress and errors / warnings will be
	 * reported through OperationLog.
	 */
	bool applyAndSave(Forwarding::Config const& config);
	
	/**
	 * \brief Provides access to the current forwarding config.
	 *
	 * To be more precise, it provides access to the config that was
	 * loaded with loadAndApply() or applied with applyAndSave() by
	 * this instance of ForwardingConfigFile.
	 */
	Forwarding::Config const& getForwardingConfig() const {
		return m_forwardingConfig;
	}
private:
	void applyFallback(ObsoleteForwardingInfo const& fallback);
	
	wxFileName m_filePath;
	Forwarding::Config m_forwardingConfig;
};

} // namespace wxGUI

#endif
