/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CheckTreeView.h"
#include <ace/config-lite.h>
#include <wx/bitmap.h>
#include <wx/colour.h>

DEFINE_LOCAL_EVENT_TYPE(myEVT_TREE_CHECK_STATE_CHANGING)
DEFINE_LOCAL_EVENT_TYPE(myEVT_TREE_CHECK_STATE_CHANGED)

BEGIN_EVENT_TABLE(CheckTreeView, wxTreeCtrl)
	EVT_TREE_STATE_IMAGE_CLICK(wxID_ANY, onStateImageClick)
	EVT_TREE_KEY_DOWN(wxID_ANY, onKeyDown)
END_EVENT_TABLE()


CheckTreeView::CheckTreeView(
	wxWindow* parent, wxWindowID id, const wxPoint& pos, const wxSize& size,
	long style, const wxValidator& validator, const wxString& name)
:	wxTreeCtrl(parent, id, pos, size, style, validator, name),
	m_imageList(16, 16, true, 6)
{
	wxBitmap cb_bitmap("CheckBoxBitmap", wxBITMAP_TYPE_BMP_RESOURCE);
	m_imageList.Add(cb_bitmap, wxColour(255, 0, 255));
	SetStateImageList(&m_imageList);
}
	
CheckTreeView::~CheckTreeView()
{
	SetStateImageList(0);
}

CheckTreeView::CheckState
CheckTreeView::GetCheckState(wxTreeItemId const& item) const
{
	return static_cast<CheckState>(
		const_cast<CheckTreeView*>(this)->GetState(item)
	);
}

void
CheckTreeView::onStateImageClick(wxTreeEvent& evt)
{
	toggleCheckState(evt.GetItem());
}

void
CheckTreeView::onKeyDown(wxTreeEvent& evt) {
	/*
	We can't just intercept the ACTIVATED event.
	The problem is the doubleclick action: it not only triggers
	the ACTIVATED event, but also causes the collapse/expand of a branch.
	*/
	evt.Skip();
	switch (evt.GetKeyCode()) {
		case WXK_SPACE:
		case WXK_RETURN:
			break;
		default:
			return;
	}
	if (GetWindowStyle() & wxTR_MULTIPLE) {
		return;
	}
	wxTreeItemId selected = GetSelection();
	if (!selected) {
		return;
	}
	toggleCheckState(selected);
}

void
CheckTreeView::toggleCheckState(wxTreeItemId const& item)
{
	CheckState state = GetCheckState(item);
	switch (state) {
		case CB_UNCHECKED: {
			doSetCheckState(item, CB_CHECKED, true);
			break;
		}
		case CB_CHECKED:
		case CB_MIXED: {
			doSetCheckState(item, CB_UNCHECKED, true);
			break;
		}
		default: break;
	}
}

void
CheckTreeView::doSetCheckState(
	wxTreeItemId const& item, CheckState new_state, bool by_user)
{
	CheckState cur_state = GetCheckState(item);
	if (new_state == cur_state) {
		return;
	}
	
	CheckTreeEvent evt(
		myEVT_TREE_CHECK_STATE_CHANGING, GetId(),
		item, cur_state, new_state, by_user
	);
	GetEventHandler()->ProcessEvent(evt);
	if (!evt.IsAllowed()) {
		return;
	}
	if (!item) {
		// the item could have been deleted by the event handler
		return;
	}
	
	SetState(item, new_state);
	evt.SetEventType(myEVT_TREE_CHECK_STATE_CHANGED);
	GetEventHandler()->ProcessEvent(evt);
}


/*=========================== CheckTreeEvent ============================*/

CheckTreeEvent::CheckTreeEvent(
	wxEventType event, int id, wxTreeItemId const& item,
	CheckState old_state, CheckState new_state,
	bool is_action_by_user)
:	wxNotifyEvent(event, id),
	m_item(item),
	m_oldState(old_state),
	m_newState(new_state),
	m_isActionByUser(is_action_by_user)
{
}

wxEvent*
CheckTreeEvent::Clone() const
{
	return new CheckTreeEvent(*this);
}
