/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2008  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef GTKGUI_WAKEUPPIPE_H_
#define GTKGUI_WAKEUPPIPE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include <sigc++/sigc++.h>
#include <glibmm/refptr.h>
#include <glibmm/main.h>

namespace GtkGUI
{

class WakeupPipe : public sigc::trackable
{
	DECLARE_NON_COPYABLE(WakeupPipe)
public:
	WakeupPipe();
	
	WakeupPipe(Glib::RefPtr<Glib::MainContext> const& context);
	
	virtual ~WakeupPipe();
	
	void wakeup();
	
	sigc::signal<void>& wakeupSignal() { return m_wakeupSignal; }
private:
	void construct(Glib::RefPtr<Glib::MainContext> const& context);
	
	bool onDataInPipe(Glib::IOCondition);
	
	int m_readFD;
	int m_writeFD;
	sigc::signal<void> m_wakeupSignal;
};

} // namespace GtkGUI

#endif
