/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef SKINNEDBUTTON_H_
#define SKINNEDBUTTON_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include <gtkmm/eventbox.h>
#include <gtkmm/image.h>
#include <glibmm/refptr.h>
#include <gdkmm/pixbuf.h>
#include <gdkmm/cursor.h>
#include <gdkmm/types.h> // for Gdk::ModifierType
#include <sigc++/sigc++.h>

namespace GtkGUI
{

class SkinnedButton : public Gtk::EventBox
{
	DECLARE_NON_COPYABLE(SkinnedButton)
public:
	SkinnedButton(Glib::RefPtr<Gdk::Pixbuf> const& skin);
	
	virtual ~SkinnedButton();
	
	void setNormalSkin(Glib::RefPtr<Gdk::Pixbuf> const& skin);
	
	void setHoverSkin(Glib::RefPtr<Gdk::Pixbuf> const& skin);
	
	void setDisabledSkin(Glib::RefPtr<Gdk::Pixbuf> const& skin);
	
	void setHoverCursor(Gdk::Cursor const& cursor);
	
	void setDisabledCursor(Gdk::Cursor const& cursor);
	
	void setEnabled(bool enabled);
	
	sigc::signal<void, Gdk::ModifierType>& signalClicked() { return m_signalClicked; }
private:
	void updateSkin();
	
	void tryUpdateCursor();
	
	bool onButtonRelease(GdkEventButton* evt);
	
	bool onMouseEnter(GdkEventCrossing*);
	
	bool onMouseLeave(GdkEventCrossing*);
	
	Gtk::Image m_image;
	Glib::RefPtr<Gdk::Pixbuf> m_ptrNormalSkin;
	Glib::RefPtr<Gdk::Pixbuf> m_ptrHoverSkin;
	Glib::RefPtr<Gdk::Pixbuf> m_ptrDisabledSkin;
	Gdk::Cursor m_hoverCursor;
	Gdk::Cursor m_disabledCursor;
	sigc::signal<void, Gdk::ModifierType> m_signalClicked;
	bool m_isEnabled;
	bool m_isMouseOver;
};

} // namespace GtkGUI

#endif
