/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef FILTERFILESTRUCTURE_H_
#define FILTERFILESTRUCTURE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ConfIO.h"
#include <string>
#include <iosfwd>
#include <list>
#include <stddef.h>

class ContentFilterList;
class ConfErrorHandler;
class RegexFilterDescriptor;
class FilterGroupTag;

class FilterFileStructure
{
public:
	void clear();
	
	void load(std::string const& text,
		ContentFilterList& target, ConfErrorHandler& eh,
		FilterGroupTag const& group_tag);
	
	void updateWith(ContentFilterList const& filters);
	
	void renameFilter(size_t pos, std::string const& new_name);
	
	void swap(FilterFileStructure& other);
	
	void toStream(std::ostream& strm) const;
	
	bool operator==(FilterFileStructure const& other) const {
		return m_elements == other.m_elements;
	}
	
	bool operator!=(FilterFileStructure const& other) const {
		return !(*this == other);
	}
private:
	struct SectionBoundries;
	class ParamValue;
	class Reader;
	class Updater;
	
	std::list<ConfIO::Element> m_elements;
};


inline void swap(FilterFileStructure& o1, FilterFileStructure& o2)
{
	o1.swap(o2);
}

inline std::ostream& operator<<(std::ostream& strm,
	FilterFileStructure const& structure)
{
	structure.toStream(strm);
	return strm;
}

#endif
