/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef RESPONSEFILTERBASE_H_
#define RESPONSEFILTERBASE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AbstractResponseFilter.h"
#include "ResponseFilterChain.h"
#include "IntrusivePtr.h"
#include "ErrorDescriptor.h"
#include "HttpResponseMetadata.h"
#include <memory>

class AsyncResponseHandler;
class HttpRequestMetadata;
class SplittableBuffer;
class ImmediateResponse;
class RequestTag;
class RequestStatus;

class ResponseFilterBase : public AbstractResponseFilter
{
public:
	ResponseFilterBase(ResponseFilterChain& chain);
	
	virtual ~ResponseFilterBase();
protected:
	void outputMetadata(
		RequestStatus& status,
		std::auto_ptr<HttpResponseMetadata> metadata);
	
	void outputBodyData(RequestStatus& status,
		SplittableBuffer& data, bool eof);
	
	void outputResponse(RequestStatus& status, ImmediateResponse& response);

	ResponseFilterChain& getFilterChain() { return m_rChain; }
	
	ResponseFilterChain const& getFilterChain() const { return m_rChain; }
	
	HttpRequestMetadata const& getRequest() const { return m_rChain.getRequest(); }
	
	RequestTag const& getRequestTag() const { return m_rChain.getRequestTag(); }
	
	AbstractResponseHandler& getFinalRecipient() { return m_rChain.getFinalRecipient(); }
private:
	class ImmediateResponseHandler;
	
	ResponseFilterChain& m_rChain;
	IntrusivePtr<AbstractResponseFilter> m_ptrNextFilter;
};

#endif
