/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HttpStatusLine.h"
#include "ArraySize.h"
#include <cstring>
#include <ostream>
#include <algorithm>

using namespace std;

HttpStatusLine::CodeMsgPair const HttpStatusLine::m_sMessageMap[] = {
	// ordered by code
	{ 100, "Continue" },
	{ 101, "Switching Protocols" },
	{ 200, "OK" },
	{ 201, "Created" },
	{ 202, "Accepted" },
	{ 203, "Non-Authoritative Information" },
	{ 204, "No Content" },
	{ 205, "Reset Content" },
	{ 206, "Partial Content" },
	{ 300, "Multiple Choices" },
	{ 301, "Moved Permanently" },
	{ 302, "Found" },
	{ 303, "See Other" },
	{ 304, "Not Modified" },
	{ 305, "Use Proxy" },
	{ 307, "Temporary Redirect" },
	{ 400, "Bad Request" },
	{ 401, "Unauthorized" },
	{ 402, "Payment Required" },
	{ 403, "Forbidden" },
	{ 404, "Not Found" },
	{ 405, "Method Not Allowed" },
	{ 406, "Not Acceptable" },
	{ 407, "Proxy Authentication Required" },
	{ 408, "Request Timeout" },
	{ 409, "Conflict" },
	{ 410, "Gone" },
	{ 411, "Length Required" },
	{ 412, "Precondition Failed" },
	{ 413, "Request Entity Too Large" },
	{ 414, "Request-URI Too Long" },
	{ 415, "Unsupported Media Type" },
	{ 416, "Requested Range Not Satisfiable" },
	{ 417, "Expectation Failed" },
	{ 500, "Internal Server Error" },
	{ 501, "Not Implemented" },
	{ 502, "Bad Gateway" },
	{ 503, "Service Unavailable" },
	{ 504, "Gateway Timeout" },
	{ 505, "HTTP Version Not Supported" }
};

HttpStatusLine::HttpStatusLine(HttpVersion const& http_version, int code)
:	m_httpVersion(http_version),
	m_code(code),
	m_message(getMessageFor(code))
{
}

HttpStatusLine::HttpStatusLine(HttpVersion const& http_version, int code, BString const& message)
:	m_httpVersion(http_version),
	m_code(code),
	m_message(message)
{
}

void
HttpStatusLine::setCodeAndMessage(int code)
{
	m_code = code;
	m_message = getMessageFor(code);
}

void
HttpStatusLine::toStream(std::ostream& strm) const
{
	if (m_httpVersion >= HttpVersion::HTTP_1_0) {
		strm << m_httpVersion << ' ' << m_code << ' ' << m_message << "\r\n";
	}
}

BString
HttpStatusLine::getMessageFor(int code)
{
	CodeMsgPair const* const end = m_sMessageMap + ARRAY_SIZE(m_sMessageMap);
	CodeMsgPair const* p = std::lower_bound(m_sMessageMap, end, code);
	if (p != end && p->code == code) {
		return BString(
			BString::ChunkPtr(), p->message,
			p->message + strlen(p->message)
		);
	}
	return BString();
}
