/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ConnectionRoute.h"

ConnectionRoute::ConnectionRoute(SymbolicInetAddr const& destination)
:	m_destination(destination)
{
}

ConnectionRoute::ConnectionRoute(
	std::vector<ProxyDescriptor> const& proxies,
	SymbolicInetAddr const& destination)
:	m_proxies(proxies),
	m_destination(destination)
{
}

ConnectionRoute::~ConnectionRoute()
{
}

SymbolicInetAddr const&
ConnectionRoute::getPhysicalPeerAddr() const
{
	if (m_proxies.empty()) {
		return m_destination;
	} else {
		return m_proxies.front().getAddr();
	}
}

void
ConnectionRoute::swap(ConnectionRoute& other)
{
	m_proxies.swap(other.m_proxies);
	m_destination.swap(other.m_destination);
}

bool operator==(ConnectionRoute const& lhs, ConnectionRoute const& rhs)
{
	if (lhs.getDestination() != rhs.getDestination()) {
		return false;
	} else if (lhs.getProxies() != rhs.getProxies()) {
		return false;
	} else {
		return true;
	}
}

bool operator<(ConnectionRoute const& lhs, ConnectionRoute const& rhs)
{
	if (lhs.getDestination() < rhs.getDestination()) {
		return true;
	} else if (rhs.getDestination() < lhs.getDestination()) {
		return false;
	} else {
		return lhs.getProxies() < rhs.getProxies();
	}
}

