/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ANALYZERESPONSEFILTER_H_
#define ANALYZERESPONSEFILTER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ResponseFilterBase.h"
#include "ResponseFilterChain.h"
#include "SplittableBuffer.h"
#include "IntrusivePtr.h"
#include "NonCopyable.h"
#include <memory>
#include <list>

class HttpResponseMetadata;
class AbstractContentIdentifier;
class RequestStatus;

class AnalyzeResponseFilter : public ResponseFilterBase
{
	DECLARE_NON_COPYABLE(AnalyzeResponseFilter)
public:
	AnalyzeResponseFilter(ResponseFilterChain& filter_chain, bool ignore_size);
	
	virtual ~AnalyzeResponseFilter();
	
	virtual void processMetadata(
		RequestStatus& status,
		std::auto_ptr<HttpResponseMetadata> metadata);
	
	virtual void processBodyData(
		RequestStatus& status, SplittableBuffer& data, bool eof);
private:
	enum State { IDENTIFYING_CONTENT, DELEGATING, FORWARDING };
	
	typedef IntrusivePtr<AbstractContentIdentifier> IdentifierPtr;
	
	void startDelegating(RequestStatus& status, bool eof);
	
	void startForwarding(RequestStatus& status, bool eof);
	
	State m_state;
	bool m_ignoreSize;
	SplittableBuffer m_data;
	std::list<IdentifierPtr> m_candidates;
	std::auto_ptr<HttpResponseMetadata> m_ptrMetadata;
	std::auto_ptr<AbstractResponseFilter> m_ptrDelegate;
};

#endif
