/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef AUTOCLOSINGSAP_H_
#define AUTOCLOSINGSAP_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*
This class gives any SAP (Service Access Point) the semantics of auto_ptr.
*/

template<typename T>
class AutoClosingSAP : public T
{
private:
	struct Rep
	{
		T sap;
		
		Rep(T const& sap) : sap(sap) {}
	};
public:
	AutoClosingSAP() {}
	
	explicit AutoClosingSAP(T& sap);
	
	AutoClosingSAP(AutoClosingSAP& other);
	
	AutoClosingSAP(Rep const& rep) : T(rep.sap) {}
	
	~AutoClosingSAP() { this->close(); }
	
	AutoClosingSAP& operator=(AutoClosingSAP& rhs);
	
	AutoClosingSAP& operator=(Rep const& rep);
	
	T release();
	
	operator Rep() { return Rep(release()); }
};


template<typename T>
AutoClosingSAP<T>::AutoClosingSAP(T& sap)
:	T(sap)
{
	sap = T();
}

template<typename T>
AutoClosingSAP<T>::AutoClosingSAP(AutoClosingSAP& other)
{
	T& to = *this;
	T& from = other;
	to = from;
	from = T();
}

template<typename T>
AutoClosingSAP<T>&
AutoClosingSAP<T>::operator=(AutoClosingSAP& rhs)
{
	T& to = *this;
	T& from = rhs;
	to.close();
	to = from;
	from = T();
	return *this;
}

template<typename T>
AutoClosingSAP<T>&
AutoClosingSAP<T>::operator=(Rep const& rep)
{
	this->close();
	static_cast<T&>(*this) = rep.sap;
	return *this;
}

template<typename T>
T
AutoClosingSAP<T>::release()
{
	T sap(*this);
	static_cast<T&>(*this) = T();
	return sap;
}

#endif
