!addPluginDir .
!define UNINST_REGKEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\BFilter"
!define MSIE_SETTINGS_REGKEY "Software\Microsoft\Windows\CurrentVersion\Internet Settings"
LangString CONFPAGE_TITLE ${LANG_ENGLISH} "Initial Configuration"
LangString CONFPAGE_SUBTITLE ${LANG_ENGLISH} "Set the options you want. Use default if not sure."
LangString CONFPAGE_PAGETITLE ${LANG_ENGLISH} ": Configuration"
LangString un.WARNPAGE_TITLE ${LANG_ENGLISH} "Warning"
LangString un.WARNPAGE_SUBTITLE ${LANG_ENGLISH} "Read this before proceeding."
LangString un.WARNPAGE_PAGETITLE ${LANG_ENGLISH} ": Warning"
LangString un.CONTINUE_CB_TEXT ${LANG_ENGLISH} "I understand the above and want to continue"
LangString un.WARNING_TEXT ${LANG_ENGLISH} "Before uninstalling BFilter you need to revert back the changes you made to your browser's proxy configuration.  Failure to do so will cause your browser to stop working.  Most people will just disable the use of proxy, but if you have been using another proxy before installing BFilter, you will have to restore it.  If you are not sure if you were using a proxy before, check if BFilter is forwarding requests to another proxy: click on BFilter's tray icon and select Configure.  If it does forward requests to another proxy, then this proxy is likely to be the one you have been using before installing BFilter.$\nIt's recommended that you first reconfigure your browser, then quit BFilter, then ensure that your browser works, and only then uninstall BFilter."
LangString UNWRITABLE_MSG ${LANG_ENGLISH} "BFilter executable already exists at the target location and is unwritable.$\nThis probably means it's currently running and you need to close it before proceeding."
LangString un.UNWRITABLE_MSG ${LANG_ENGLISH} "Some of the files can't be deleted.$\nThis probably means the application is still running and you need to close it before proceeding."
LangString WIN2K_REQUIRED_MSG ${LANG_ENGLISH} "This BFilter build requires Windows 2000 or above.$\nA build supporing earlier Windows versions is available on the website."

Var PREV_INSTALL_DIR

SetCompressor lzma

!include "MUI.nsh"

!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\win-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\win-uninstall.ico"
!define MUI_HEADERIMAGE
!define MUI_HEADERIMAGE_BITMAP "${NSISDIR}\Contrib\Graphics\Header\orange.bmp"
!define MUI_HEADERIMAGE_UNBITMAP "${NSISDIR}\Contrib\Graphics\Header\orange-uninstall.bmp"

; <Pages>
!insertmacro MUI_PAGE_LICENSE "License.txt"

!define MUI_PAGE_CUSTOMFUNCTION_LEAVE onDirPageLeave
!insertmacro MUI_PAGE_DIRECTORY

!insertmacro MUI_PAGE_INSTFILES

Page custom showConfigPage applyConfig "$(CONFPAGE_PAGETITLE)"

UninstPage custom un.showWarningPage un.onWarnPageLeave "$(un.WARNPAGE_PAGETITLE)"

!insertmacro MUI_UNPAGE_INSTFILES
; </Pages>

!insertmacro MUI_LANGUAGE "English"

!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS
ReserveFile ProxySettings.dll Unwarn.dll

Name "BFilter"
SetOverwrite on
OutFile "bfilter-${VERSION}-install.exe"
InstallDir "$PROGRAMFILES\BFilter"
InstallDirRegKey HKLM "${UNINST_REGKEY}" "InstallLocation"
ShowInstDetails hide
ShowUnInstDetails hide

Section "MainSection"
  SetOutPath "$INSTDIR"
  File "bfilter.exe"
  File /r "doc"
  SetOutPath "$INSTDIR\conf"
  File /r "filters"

  File "config.default"
  IfFileExists "$INSTDIR\conf\config" conf_exists
    File /oname=config "config.default"
  conf_exists:
  File "urls"
  IfFileExists "$INSTDIR\conf\urls.local" urls_local_exists
    File "urls.local"
  urls_local_exists:

  ; Remove files from older versions
  Delete "$INSTDIR\mingwm10.dll"
  Delete "$INSTDIR\conf\rules"
  Delete "$INSTDIR\conf\rules.local"
  Delete "$INSTDIR\conf\filters\Remove popups and other annoyances"
  Delete "$INSTDIR\conf\filters\Remove popups and other annoyances.enabled"

  WriteRegStr HKLM "${UNINST_REGKEY}" "InstallLocation" "$INSTDIR"
  WriteRegStr HKLM "${UNINST_REGKEY}" "Version" "${VERSION}"
  WriteRegStr HKLM "${UNINST_REGKEY}" "DisplayVersion" "${VERSION}"
  WriteRegStr HKLM "${UNINST_REGKEY}" "DisplayName" "BFilter"
  WriteRegStr HKLM "${UNINST_REGKEY}" "DisplayIcon" "$INSTDIR\bfilter.exe"
  WriteRegStr HKLM "${UNINST_REGKEY}" "UninstallString" '"$INSTDIR\Uninstall.exe"'
  WriteRegStr HKLM "${UNINST_REGKEY}" "HelpLink" "http://bfilter.sf.net"
  WriteRegStr HKLM "${UNINST_REGKEY}" "URLInfoAbout" "http://bfilter.sf.net"
  WriteRegStr HKLM "${UNINST_REGKEY}" "URLUpdateInfo" "http://bfilter.sf.net"

  SetOutPath "$INSTDIR"
  SetShellVarContext all
  CreateDirectory "$SMPROGRAMS\BFilter"
  CreateShortCut "$SMPROGRAMS\BFilter\BFilter.lnk" "$INSTDIR\bfilter.exe"
  CreateShortCut "$SMPROGRAMS\BFilter\Uninstall.lnk" "$INSTDIR\Uninstall.exe"
  CreateShortCut "$SMPROGRAMS\BFilter\BFilter Website.lnk" "http://bfilter.sourceforge.net"
  CreateShortCut "$SMPROGRAMS\BFilter\Documentation.lnk" "$INSTDIR\doc\index.html"

  WriteUninstaller "$INSTDIR\Uninstall.exe"
SectionEnd

Function .onInit
  StrCmp ${WIN9X_SUPPORT} "1" skip_nt_check
    ClearErrors
    ReadRegStr $R0 HKLM \
    "SOFTWARE\Microsoft\Windows NT\CurrentVersion" CurrentVersion
    IfErrors "" nt
      MessageBox MB_OK|MB_ICONEXCLAMATION "$(WIN2K_REQUIRED_MSG)"
      Abort
    nt:
  skip_nt_check:
  !insertmacro MUI_INSTALLOPTIONS_EXTRACT "lastpage.ini"
  ReadRegStr $PREV_INSTALL_DIR HKLM "${UNINST_REGKEY}" "InstallLocation"
  StrCmp $PREV_INSTALL_DIR "" done
  IfFileExists "$PREV_INSTALL_DIR\conf\config" done
    StrCpy $PREV_INSTALL_DIR ""
  done:
FunctionEnd

Function onDirPageLeave
  IfFileExists "$INSTDIR\bfilter.exe" "" ok
  ClearErrors
  FileOpen $R0 "$INSTDIR\bfilter.exe" "a"
  IfErrors "" open_success
    ClearErrors
    MessageBox MB_OK|MB_ICONEXCLAMATION "$(UNWRITABLE_MSG)"
    Abort
  open_success:
  FileClose $R0
  ok:
FunctionEnd

Function showConfigPage
  StrCmp $PREV_INSTALL_DIR "" no_prev_install
    !insertmacro MUI_INSTALLOPTIONS_WRITE "lastpage.ini" "Field 4" "State" "1"
    !insertmacro MUI_INSTALLOPTIONS_WRITE "lastpage.ini" "Field 5" "State" "0"
  no_prev_install:
  !insertmacro MUI_HEADER_TEXT "$(CONFPAGE_TITLE)" "$(CONFPAGE_SUBTITLE)"
  !insertmacro MUI_INSTALLOPTIONS_DISPLAY "lastpage.ini"
FunctionEnd

Function applyConfig
  StrCmp $PREV_INSTALL_DIR "" "" done_with_proxy_settings
    ReadRegDWORD $R0 HKCU "${MSIE_SETTINGS_REGKEY}" "ProxyEnable"
    ReadRegStr $R1 HKCU "${MSIE_SETTINGS_REGKEY}" "ProxyServer"
    ProxySettings::process $R0 $R1
    Pop $R0 ; proxy enabled
    Pop $R1 ; proxy host
    Pop $R2 ; proxy port
    StrCmp $R0 "1" proxy_enabled
    StrCpy $R0 "no"
    Goto skip_enabled
    proxy_enabled:
    StrCpy $R0 "yes"
    skip_enabled:
    WriteINIStr "$INSTDIR\conf\config" "forwarding" "use_proxy" "$R0"
    WriteINIStr "$INSTDIR\conf\config" "forwarding" "proxy_type" "http"
    WriteINIStr "$INSTDIR\conf\config" "forwarding" "proxy_host" "$R1"
    WriteINIStr "$INSTDIR\conf\config" "forwarding" "proxy_port" "$R2"
  done_with_proxy_settings:

  !insertmacro MUI_INSTALLOPTIONS_READ $R0 "lastpage.ini" "Field 1" "State"
  StrCmp $R0 "1" "" no_autostart
    SetShellVarContext current
    CreateShortCut "$SMSTARTUP\BFilter.lnk" "$INSTDIR\bfilter.exe"
    Goto autostart_done
  no_autostart:
    SetShellVarContext current
    Delete "$SMSTARTUP\BFilter.lnk"
  autostart_done:
  !insertmacro MUI_INSTALLOPTIONS_READ $R0 "lastpage.ini" "Field 2" "State"
  StrCmp $R0 "1" "" dont_start_now
    Exec '"$INSTDIR\bfilter.exe"'
  dont_start_now:
  !insertmacro MUI_INSTALLOPTIONS_READ $R0 "lastpage.ini" "Field 5" "State"
  StrCmp $R0 "1" "" skip_documentation
    ExecShell open "$INSTDIR\doc\index.html"
  skip_documentation:
FunctionEnd

Section Uninstall
  SetShellVarContext all
  RMDir /r "$SMPROGRAMS\BFilter"
  SetShellVarContext current
  Delete "$SMSTARTUP\BFilter.lnk"

  RMDir /r "$INSTDIR\conf"
  RMDir /r "$INSTDIR\doc"

  Delete "$INSTDIR\bfilter.exe"
  RMDir /r "$INSTDIR\backend"
  Delete "$INSTDIR\mingwm10.dll"  ; older version included it
  Delete "$INSTDIR\Uninstall.exe"

  DeleteRegKey HKLM "${UNINST_REGKEY}"

  RMDir "$INSTDIR"
SectionEnd

Function un.showWarningPage
  !insertmacro MUI_HEADER_TEXT "$(un.WARNPAGE_TITLE)" "$(un.WARNPAGE_SUBTITLE)"
  Unwarn::show "$(un.WARNING_TEXT)" "$(un.CONTINUE_CB_TEXT)"
  Pop $R0
FunctionEnd

Function un.onWarnPageLeave
  IfFileExists "$INSTDIR\bfilter.exe" "" ok
  ClearErrors
  FileOpen $R0 "$INSTDIR\bfilter.exe" "a"
  IfErrors "" open_success
    ClearErrors
    MessageBox MB_OK|MB_ICONEXCLAMATION "$(UNWRITABLE_MSG)"
    Abort
  open_success:
  FileClose $R0
  ok:
FunctionEnd
