#!/bin/sh

# TODO: check that the release build is not older than the debug one.

if [ "$EUID" -ne 0 ]; then
  echo "Root access is required to set ownership of files."
  echo "Use like this: sudo ./prepare.sh"
  exit 1
fi

STARTUP_ITEMS="./PreparedPackage/Contents/StartupItems"
APP_SUPPORT="./PreparedPackage/Contents/Application Support"
RESOURCES="./PreparedPackage/Resources"

rm -rf ./PreparedPackage &&
cp -rp ./Package ./PreparedPackage &&
find ./PreparedPackage -name "CVS" -o -name ".*" -exec rm -f {} \;  &&
cp -p ../../COPYING ./PreparedPackage/License.txt &&
cp -p ../../build/Release/daemon "$STARTUP_ITEMS/BFilter/BFilterDaemon" &&
cp -p ../../conf/config.default "$APP_SUPPORT/BFilter/config" &&
cp -p ../../conf/urls "$APP_SUPPORT/BFilter/urls" &&
cp -p ../../conf/urls.local "$APP_SUPPORT/BFilter/urls.local" &&
cp -rp ../../conf/filters "$APP_SUPPORT/BFilter/filters" &&
chown -R root:wheel "$STARTUP_ITEMS" &&
chmod +x "$STARTUP_ITEMS/BFilter" &&
chmod -R u+rw,g+r-w,o+r-w "$STARTUP_ITEMS" &&
chown -R root:admin "$APP_SUPPORT" &&
chmod -R u+rw,g+rw,o+r-w "$APP_SUPPORT"

if [ $? -ne 0 ]; then
  echo "Failed"
  rm -rf ./PreparedPackage
  exit 1
fi

cat <<END

Now do the following steps:
1. Go to PreparedPackage and open BFilter.pmproj.
2. Adjust the version if necessary.
3. Click Project -> Build and save BFilter.pkg to DmgDir.
4. Run build-dmg.sh
END
