/*
    BFilter - a web proxy which removes banner ads
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HTMLLEXER_H_
#define HTMLLEXER_H_

#include "HtmlLexerCore.h"

class HtmlLexer : public HtmlLexerCore
{
public:
	HtmlLexer() : HtmlLexerCore(this) {}
	
	virtual ~HtmlLexer() {}
	
	virtual void processDocType(Iterator const& begin, Iterator const& end) = 0;

	virtual void processText(Iterator const& begin, Iterator const& end) = 0;
	
	virtual void processComment(Iterator const& begin, Iterator const& end) = 0;
	
	virtual void processCDATA(Iterator const& begin, Iterator const& end) = 0;
	
	virtual void processOpeningTagName(Iterator const& begin, Iterator const& end) = 0;
	
	virtual void processOpeningTag(Iterator const& begin, Iterator const& end, bool explicit_empty) = 0;
	
	virtual void processClosingTagName(Iterator const& begin, Iterator const& end) = 0;
	
	virtual void processClosingTag(Iterator const& begin, Iterator const& end, bool noscript_follows = false) = 0;
	
	virtual bool processAttrName(Iterator const& begin, Iterator const& end) = 0;
	
	virtual void processAttrValue(Iterator const& begin, Iterator const& end) = 0;
	
	virtual void processAttrNullValue() = 0;
	
	virtual bool isCDATAStarting() const = 0;
	
	virtual bool isCDATAEnding(Iterator const& begin, Iterator const& end) const = 0;
	
	virtual bool isNoscriptToBeExpected() const = 0;
};

#endif
