/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "TrayMenu.h"
#include "Application.h"
#include "GlobalState.h"
#include <gtkmm/stock.h>
#include <memory>

using namespace std;

TrayMenu::TrayMenu()
:	m_pActiveItem(0),
	m_isActiveItemSelected(false)
{
	auto_ptr<Gtk::Menu> config_submenu(new Gtk::Menu);
	config_submenu->items().push_back(
		Gtk::Menu_Helpers::MenuElem(
			"Basic",
			sigc::mem_fun(*this, &TrayMenu::onBasicConfig)
		)
	);
	config_submenu->items().push_back(
		Gtk::Menu_Helpers::MenuElem(
			"Advanced",
			sigc::mem_fun(*this, &TrayMenu::onAdvancedConfig)
		)
	);
	config_submenu->items().push_back(
		Gtk::Menu_Helpers::MenuElem(
			"Filters",
			sigc::mem_fun(*this, &TrayMenu::onFilterConfig)
		)
	);
	
	auto_ptr<Gtk::Menu> log_submenu(new Gtk::Menu);
	log_submenu->items().push_back(
		Gtk::Menu_Helpers::MenuElem(
			"Operations",
			sigc::mem_fun(*this, &TrayMenu::onOperationLog)
		)
	);
	log_submenu->items().push_back(
		Gtk::Menu_Helpers::MenuElem(
			"Requests",
			sigc::mem_fun(*this, &TrayMenu::onRequestLog)
		)
	);
	
	items().push_back(
		Gtk::Menu_Helpers::CheckMenuElem(
			"Active",
			sigc::mem_fun(*this, &TrayMenu::onActive)
		)
	);
	m_pActiveItem = dynamic_cast<Gtk::CheckMenuItem*>(&items().back());
	m_pActiveItem->signal_select().connect(
		sigc::mem_fun(*this, &TrayMenu::onActiveSelected)
	);
	m_pActiveItem->signal_deselect().connect(
		sigc::mem_fun(*this, &TrayMenu::onActiveDeselected)
	);
	
	items().push_back(Gtk::Menu_Helpers::SeparatorElem());
	
#ifdef DEBUG
	items().push_back(
		Gtk::Menu_Helpers::MenuElem(
			"Debug",
			sigc::mem_fun(*this, &TrayMenu::onDebug)
		)
	);
#endif
	items().push_back(
		Gtk::Menu_Helpers::MenuElem(
			"Configuration", *manage(config_submenu.release())
		)
	);
	items().push_back(
		Gtk::Menu_Helpers::MenuElem(
			"Log", *manage(log_submenu.release())
		)
	);
	
	items().push_back(Gtk::Menu_Helpers::SeparatorElem());
	
	items().push_back(
		Gtk::Menu_Helpers::MenuElem(
			"About",
			sigc::mem_fun(*this, &TrayMenu::onAbout)
		)
	);
	items().push_back(
		Gtk::Menu_Helpers::StockMenuElem(
			Gtk::Stock::QUIT,
			sigc::mem_fun(*this, &TrayMenu::onQuit)
		)
	);
	
	bool filtering_enabled = GlobalState::ReadAccessor()->isFilteringEnabled();
	// Calling set_active(GlibalState::ReadAccessor()->...) would lead to a deadlock.
	m_pActiveItem->set_active(filtering_enabled);
}

void
TrayMenu::updateActiveItemText()
{
	bool const active = m_pActiveItem->get_active();
	Gtk::Label* label = dynamic_cast<Gtk::Label*>(m_pActiveItem->get_child());
	if (m_isActiveItemSelected) {
		label->set_text(active ? "Deactivate" : "Activate");
	} else {
		label->set_text(active ? "Active" : "Passive");
	}
}

#include <iostream>

void
TrayMenu::onActive()
{
	updateActiveItemText();
	bool const active = m_pActiveItem->get_active();
	GlobalState::WriteAccessor()->setFilteringEnabled(active);
}

void
TrayMenu::onActiveSelected()
{
	m_isActiveItemSelected = true;
	updateActiveItemText();
}

void
TrayMenu::onActiveDeselected()
{
	m_isActiveItemSelected = false;
	updateActiveItemText();
}

void
TrayMenu::onBasicConfig()
{
	Application::instance()->showBasicConfigDialog();
}

void
TrayMenu::onAdvancedConfig()
{
	Application::instance()->showAdvancedConfigWindow();
}

void
TrayMenu::onFilterConfig()
{
	Application::instance()->showFilterConfigWindow();
}

void
TrayMenu::onOperationLog()
{
	Application::instance()->showLogDialog();
}

void
TrayMenu::onRequestLog()
{
	Application::instance()->showRequestLogWindow();
}

#ifdef DEBUG
void
TrayMenu::onDebug()
{
	Application::instance()->showDebugWindow();
}
#endif

void
TrayMenu::onAbout()
{
	Application::instance()->showAboutDialog();
}

void
TrayMenu::onQuit()
{
	Application::instance()->requestAppExit();
}
