/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "TextPattern.h"
#include <algorithm>
#include <cstring>

using namespace std;

TextPattern::TextPattern(std::string const& source, InvalidTag)
:	m_source(source),
	m_isValid(false)
{
}

TextPattern::TextPattern(
	std::string const& source, boost::regex::flag_type flags)
:	m_source(source),
	m_isValid(false)
{
	char const* begin = source.data();
	char const* end = begin + source.size();
	if (begin != end && begin[0] == '/' && end[-1] == '/') {
		boost::regex re(begin + 1, end - 1, flags);
		m_regex.swap(re);
	} else {
		boost::regex re(globToRegex(source), flags);
		m_regex.swap(re);
	}
	m_isValid = true;
}

void
TextPattern::swap(TextPattern& other)
{
	m_source.swap(other.m_source);
	m_regex.swap(other.m_regex);
	std::swap(m_isValid, other.m_isValid);
}

std::string
TextPattern::globToRegex(std::string const& glob)
{
	static char const metachars[] = {
		'.', '\\', '+',
		/*'*', '?',*/ // we are assigning a new meaning to these
		'[', '^', ']', '$',
		'(', ')', '{', '}', '|'
		/*, '=', '!', '<', '>', ':'*/
		// these only have a special meaning when
		// enclosed with other metacharacters
	};
	
	string regex;
	regex.reserve(glob.size() * 2);
	char const* p = glob.data();
	char const* const end = p + glob.size();
	
	for (; p != end; ++p) {
		char const ch = *p;
		if (ch == '?') {
			regex += '.';
		} else if (ch == '*') {
			regex += ".*?";
		} else if (memchr(metachars, ch, sizeof(metachars))) {
			regex += '\\';
			regex += ch;
		} else {
			regex += ch;
		}
	}
	
	return regex;
}
