/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef REQUESTLOG_H_
#define REQUESTLOG_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

class AbstractRequestLogHandler;
class RequestTag;
class URI;

class RequestLog
{
public:
	enum RequestType {
		NORMAL_REQUEST,
		SUBST_REQUEST,   // like http://somehost.com/bf-si-88x31/img.gif
		ANALYZE_REQUEST, // like http://somehost.com/bf-analyze/img.gif
		INTERNAL_REQUEST // script fetches during html processing
	};
	
	static void logRequest(
		RequestTag const& tag, URI const& uri, RequestType type);
	
	static void logResponseBegin(RequestTag const& tag, int status_code);
	
	static void logResponseEnd(RequestTag const& tag) { doLogResponseEnd(tag, false); }
	
	static void logResponseError(RequestTag const& tag) { doLogResponseEnd(tag, true); }
	
	static void logRequestCancel(RequestTag const& tag);
	
	static AbstractRequestLogHandler* getHandler() { return m_spHandler; }
	
	static void setHandler(AbstractRequestLogHandler* handler) { m_spHandler = handler; }
private:
	class RequestCommand;
	class ResponseBeginCommand;
	class ResponseEndCommand;
	class RequestCancelCommand;
	
	static void doLogResponseEnd(RequestTag const& tag, bool error);
	
	static AbstractRequestLogHandler* m_spHandler;
};

#endif
