/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HttpStateSizedFlatBody.h"
#include "HttpParserBase.h"
#include "SplittableBuffer.h"
#include <string>

using namespace std;

HttpStateSizedFlatBody::HttpStateSizedFlatBody(HttpParserBase& parser)
:	m_rParser(parser)
{
}

HttpStateSizedFlatBody::~HttpStateSizedFlatBody()
{
}

void
HttpStateSizedFlatBody::activate(uintmax_t size)
{
	m_remainingSize = size;
}

HttpState*
HttpStateSizedFlatBody::processNewData(SplittableBuffer& input, bool eof,
                                       SplittableBuffer& body_data, bool& body_eof)
{
	size_t input_size = input.size();
	if (m_remainingSize <= input_size) {
		input.splitFrontAppendBack(m_remainingSize, body_data);
		body_eof = true;
		return m_rParser.activateStateInactive();
	}
	m_remainingSize -= input_size;
	body_data.appendDestructive(input);
	if (eof) {
		return m_rParser.activateStateError("unexpected end of data (in HttpStateSizedFlatBody)");
	}
	return this;
}
