/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HttpMethodRegistry.h"
#include "ArraySize.h"
#include "BString.h"
#include <cstring>
#include <algorithm>

using namespace std;

// here we list only supported methods
char const* const HttpMethodRegistry::m_sMethods[] = {
	// these are in alphabetic order
	"BCOPY",
	"BDELETE",
	"BMOVE",
	"BPROPFIND",
	"BPROPPATCH",
	"CONNECT",
	"COPY",
	"DELETE",
	"GET",
	"HEAD",
	"LOCK",
	"MKCOL",
	"MOVE",
	"POLL",
	"POST",
	"PROPFIND",
	"PROPPATCH",
	"PUT",
	"SEARCH",
	"SUBSCRIBE",
	"UNLOCK",
	"UNSUBSCRIBE"
};
/* TODO:
OPTIONS, TRACE: special support required + handle Max-Forwards header
*/


struct HttpMethodRegistry::Comparator
{
	Comparator() {}
	
	bool operator()(char const* lhs, char const* rhs) const {
		return strcmp(lhs, rhs) < 0;
	}
	
	bool operator()(char const* lhs, BString const& rhs) const {
		BString empty;
		BString lhs_bs(empty, lhs, lhs + strlen(lhs));
		return lhs_bs < rhs;
	}
	
	bool operator()(BString const& lhs, char const* rhs) const {
		BString empty;
		BString rhs_bs(empty, rhs, rhs + strlen(rhs));
		return lhs < rhs_bs;
	}
};

bool
HttpMethodRegistry::find(char const* method_name)
{
	Comparator less;
	char const* const* end = m_sMethods + ARRAY_SIZE(m_sMethods);
	char const* const* res = std::lower_bound(m_sMethods, end, method_name, less);
	return (res != end && !less(method_name, *res));
}

bool
HttpMethodRegistry::find(BString const& method_name)
{
	Comparator less;
	char const* const* end = m_sMethods + ARRAY_SIZE(m_sMethods);
	char const* const* res = std::lower_bound(m_sMethods, end, method_name, less);
	return (res != end && !less(method_name, *res));
}
