/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HttpMessageShaper.h"
#include "HttpRequestMetadata.h"
#include "HttpResponseMetadata.h"
#include "HttpRequestLine.h"
#include "HttpStatusLine.h"
#include "HttpHeadersCollection.h"
#include "HttpHeader.h"
#include "HttpVersion.h"
#include "BString.h"
#include "StringUtils.h"
#include "InsensitiveEqual.h"
#include "URI.h"
#include <string>

using namespace std;

void
HttpMessageShaper::shapeRequest(HttpRequestMetadata& request)
{
	removeUnsupportedFeatures(
		request.headers(),
		request.requestLine().getHttpVersion()
	);
	normalizeReferer(request.headers());
}

void
HttpMessageShaper::shapeResponse(
	HttpResponseMetadata& response, HttpRequestLine const& request_line)
{
	removeUnsupportedFeatures(
		response.headers(),
		response.statusLine().getHttpVersion()
	);
}

void
HttpMessageShaper::removeUnsupportedFeatures(
	HttpHeadersCollection& headers, HttpVersion const& http_vers)
{
	if (http_vers >= HttpVersion::HTTP_1_1) {
		return;
	}
	
	// the following headers might have been mistakenly forwarded by
	// a HTTP/1.0 only proxy.
	headers.removeHeader(BString("Expect"));
	headers.removeHeader(BString("TE"));
	headers.removeHeader(BString("Transfer-Encoding"));
	headers.removeHeader(BString("Upgrade"));
}

void
HttpMessageShaper::normalizeReferer(HttpHeadersCollection& headers)
{
	// remove "bf-analyze" or "bf-analyze-is" from the Referer
	BString const prefix("bf-analyze");
	BString const is_str("-is");
	BString const referer("Referer");
	URI new_ref(headers.getHeader(referer).getValue());
	BString path = new_ref.getRawPath();
	if (StringUtils::startsWith(path.begin(), path.end(),
	                            prefix.begin(), prefix.end())) {
		path.trimFront(prefix.size());
		if (StringUtils::startsWith(path.begin(), path.end(),
		                            is_str.begin(), is_str.end())) {
			path.trimFront(is_str.size());
		}
		if (!path.empty()) {
			if (path[0] == '/') {
				path.trimFront(1);
			} else {
				return;
			}
		}
		new_ref.setAbsoluteRawPath(path);
		headers.setHeader(HttpHeader(referer, new_ref.toBString()));
	}
}
