/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "CFUtils.h"
#include <stdarg.h>

ArrayRef
CFUtils::createCFTypeArray(CFTypeRef first, ...)
{
	MutableArrayRef arr(
		CFArrayCreateMutable(NULL, 0, &kCFTypeArrayCallBacks),
		NORETAIN
	);
	if (first) {
		CFArrayAppendValue(arr, first);
		va_list args;
		va_start(args, first);
		CFTypeRef val;
		while ((val = va_arg(args, CFTypeRef))) {
			CFArrayAppendValue(arr, val);
		}
		va_end(args);
	}
	return arr;
}

StringRef
CFUtils::composePath(CFStringRef first, ...)
{
	MutableStringRef path(
		CFStringCreateMutable(NULL, 0), NORETAIN
	);
	
	CFStringRef slash = CFSTR("/");
	if (!first || !CFStringHasPrefix(first, slash)) {
		CFStringAppend(path, slash);
	}
	
	if (first) {
		CFStringAppend(path, first);
		va_list args;
		va_start(args, first);
		CFStringRef val;
		while ((val = va_arg(args, CFStringRef))) {
			CFStringAppend(path, slash);
			CFStringAppend(path, val);
		}
		va_end(args);
	}
	return path;
}

StringRef
CFUtils::extractLastPathComponent(StringRef const& path)
{
	CFRange range = CFStringFind(path, CFSTR("/"), kCFCompareBackwards);
	if (range.location == kCFNotFound) {
		return path;
	}
	
	CFIndex path_length = CFStringGetLength(path);
	range.location += range.length;
	range.length = path_length - range.location;
	return StringRef(CFStringCreateWithSubstring(NULL, path, range), NORETAIN);
}

StringRef
CFUtils::removeStringPrefix(StringRef const& string, CFStringRef const& prefix)
{
	if (!CFStringHasPrefix(string, prefix)) {
		return string;
	}
	
	CFIndex string_len = CFStringGetLength(string);
	CFIndex prefix_len = CFStringGetLength(prefix);
	CFRange range = CFRangeMake(prefix_len, string_len - prefix_len);
	
	StringRef res(
		CFStringCreateWithSubstring(NULL, string, range),
		NORETAIN
	);
	return res;
}
