/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef SOCKS4ASYNCCONNECTOR_H_
#define SOCKS4ASYNCCONNECTOR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include "EventHandler.h"
#include "Reactor.h"
#include "Observer.h"
#include "Socks4Requester.h"
#include "AutoClosingSAP.h"
#include <ace/config-lite.h>
#include <ace/SOCK_Stream.h>
#include <string>

class InetAddr;
class SymbolicInetAddr;
class TimeDelta;
class SocksError;
class SocksConnectorListener;

namespace BuggyMsvcWorkaround {
typedef Socks4Requester::Listener Socks4RequesterListener;
}

class Socks4AsyncConnector :
	private EventHandlerBase,
	private BuggyMsvcWorkaround::Socks4RequesterListener
{
	DECLARE_NON_COPYABLE(Socks4AsyncConnector)
public:
	enum Socks4aTag { SOCKS4A };
	
	typedef SocksConnectorListener Listener;
	
	Socks4AsyncConnector();
	
	virtual ~Socks4AsyncConnector();
	
	bool isInProgress() const { return m_state != ST_INACTIVE; }
	
	void initiate(Listener& listener, Reactor& reactor,
		AutoClosingSAP<ACE_SOCK_Stream>& proxy_conn,
		InetAddr const& target_addr,
		std::string const& username, TimeDelta const* timeout = 0);
	
	void initiate(Socks4aTag, Listener& listener, Reactor& reactor,
		AutoClosingSAP<ACE_SOCK_Stream>& proxy_conn,
		SymbolicInetAddr const& target_addr,
		std::string const& username, TimeDelta const* timeout = 0);
	
	void abort();
private:
	enum State {
		ST_INACTIVE,
		ST_REQUESTING_CONNECTION
	};
	
	virtual void ref();
	
	virtual void unref();
	
	virtual void handleTimeout(ReactorTimerId const& timer_id);
	
	virtual void onRequestSuccess();
	
	virtual void onRequestFailure(SocksError const& err);
	
	void initiateCommon(
		Listener& listener, Reactor& reactor,
		AutoClosingSAP<ACE_SOCK_Stream>& proxy_conn,
		TimeDelta const* timeout);
	
	void unregisterTimer();
	
	void handleConnectFailure(SocksError const& err);
	
	SingleObserverLink<Listener> m_observerLink;
	State m_state;
	int m_refCount;
	AutoClosingSAP<ACE_SOCK_Stream> m_proxyConn;
	Reactor* m_pReactor;
	ReactorTimerId m_timeoutTimerId;
	Socks4Requester m_requester;
};

#endif
