/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HTTPHEADER_H_
#define HTTPHEADER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HttpHeaderElement.h"
#include "BString.h"
#include <list>
#include <iosfwd>

class HttpHeader
{
public:
	HttpHeader(BString const& name, BString const& value);
	
	~HttpHeader();
	
	BString const& getName() const { return m_name; }
	
	std::list<BString> const& getValues() const { return m_values; }
	
	void setValues(std::list<BString> const& values) { m_values = values; }
	
	void appendValue(BString const& value) { m_values.push_back(value); }
	
	BString getValue() const;
	
	void setValue(BString const& value);
	
	void toStream(std::ostream& strm) const;
private:
	BString m_name;
	std::list<BString> m_values;
};

inline std::ostream&
operator<<(std::ostream& strm, HttpHeader const& header)
{
	header.toStream(strm);
	return strm;
}

#endif
