/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef DOWNLOADPROGRESS_H_
#define DOWNLOADPROGRESS_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "types.h"

class DownloadProgress
{
public:
	static uintmax_t const UNDEFINED = ~uintmax_t(0);
	
	DownloadProgress() : m_total(UNDEFINED), m_received(0) {}
	
	explicit DownloadProgress(uintmax_t total, uintmax_t received = 0)
	: m_total(total), m_received(received) {}
	
	uintmax_t& total() { return m_total; }
	
	uintmax_t const& total() const { return m_total; }
	
	uintmax_t& received() { return m_received; }
	
	uintmax_t const& received() const { return m_received; }
	
	void reset() { m_total = UNDEFINED; m_received = 0; }
private:
	uintmax_t m_total;
	uintmax_t m_received;
};

#endif
