/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef DEFLATEDECOMPRESSOR_H_
#define DEFLATEDECOMPRESSOR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "types.h"
#include "AbstractDecompressor.h"
#include "NonCopyable.h"
#include "SplittableBuffer.h"
#include <zlib.h>
#include <stddef.h>
#include <limits>

class DeflateDecompressor : public AbstractDecompressor
{
	DECLARE_NON_COPYABLE(DeflateDecompressor)
public:
	enum Flavor { ZLIB, RAW, AUTODETECT };

	DeflateDecompressor(Flavor flavor);
	
	virtual ~DeflateDecompressor();
	
	virtual void reset();
	
	virtual bool isError() const;
	
	virtual void consume(SplittableBuffer& data, bool eof);
	
	virtual size_t retrieveOutput(SplittableBuffer& buf,
		size_t limit = std::numeric_limits<size_t>::max());
private:
	enum { MAX_OUTBUF_SIZE = 16384 };
	enum State { ST_DETECTING_FLAVOR, ST_DECOMPRESSING, ST_ERROR };
	
	struct OperationContext;
	
	void initStream(bool zlib_flavor);
	
	void decompress(
		uint8_t const*& begin, uint8_t const* end,
		SplittableBuffer& out, OperationContext& ctx);
	
	static char const ZLIB_SIGNATURE[];
	Flavor m_flavor;
	State m_state;
	SplittableBuffer m_bufferedInput;
	bool m_isEOF;
	bool m_isStreamReady;
	z_stream m_strm;
};

#endif
