/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ASYNCREADERWRITER_H_
#define ASYNCREADERWRITER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include "Reactor.h"
#include "EventHandler.h"
#include "Observer.h"
#include <ace/config-lite.h>
#include <stddef.h>

class AsyncReaderWriter : private EventHandlerBase
{
	DECLARE_NON_COPYABLE(AsyncReaderWriter)
public:
	class Listener;
	
	AsyncReaderWriter();
	
	virtual ~AsyncReaderWriter();
	
	void activate(Listener& listener, Reactor& reactor, ACE_HANDLE handle);
	
	void deactivate();
	
	void startReading(void* addr, size_t len);
	
	void startWriting(void const* addr, size_t len);
	
	void stopReading();
	
	void stopWriting();
private:
	virtual void ref();
	
	virtual void unref();
	
	virtual void handleRead(ACE_HANDLE);
	
	virtual void handleWrite(ACE_HANDLE);
	
	void unregisterHandler();
	
	void tryReading();
	
	void tryWriting();
	
	static void setNonBlockingMode(ACE_HANDLE handle);
	
	SingleObserverLink<Listener> m_observerLink;
	int m_refCount;
	Reactor* m_pReactor;
	ACE_HANDLE m_handle;
	ReactorHandlerId m_handlerId;
	char* m_pReadAddr;
	size_t m_readTodo;
	char const* m_pWriteAddr;
	size_t m_writeTodo;
	unsigned char m_tryReadingNestLevel; //
	unsigned char m_tryWritingNestLevel; // they actually don't go above 1
	unsigned char m_isReadScheduled;
	unsigned char m_isWriteScheduled;
};


class AsyncReaderWriter::Listener : public ObserverBase
{
public:
	virtual ~Listener() {}
	
	virtual void onReadDone() = 0;
	
	virtual void onReadError() = 0;
	
	virtual void onWriteDone() = 0;
	
	virtual void onWriteError() = 0;
	
	virtual void onGenericError() = 0;
};

#endif
