#include "config.h"

#ifdef HAVE_TCL

#include <tcl.h>
#include <stdarg.h>
#include <strings.h>

#include "bezerk.h"
#include "irc.h"
#include "util.h"
#include "tcl_script.h"
#include "ch_utils.h"

extern Tcl_Interp *interp;
extern GdkColor colour_white;

struct hooks {
  char *hookname;
  char *funcname;
  int  argnum;
} onhooks[] =
{
  {"kick", NULL, 5},
  {"privmsgme", NULL, 3},
  {"privmsgchan", NULL, 4},
  {"noticeme", NULL, 3},
  {"noticechan", NULL, 4},
  {"join", NULL, 3},
  {"part", NULL, 3},
  {"quit", NULL, 3},
  {"nick", NULL, 3},
  {"topic", NULL, 4},
  {"invite", NULL, 3},
  {"kill", NULL, 4},
  {"mode", NULL, 5},
  {"chanmode", NULL, 4}
};

/* allows you to compose raw irc messages   */ 
int Tcl_send_command (ClientData cd, Tcl_Interp *interp, int argc, char *argv[])
{
  if (argc != 2)
    return TCL_ERROR;
  irc_send_message(argv[1]);
  return TCL_OK;
}

/* on hooks  */ 
int Tcl_On (ClientData cd, Tcl_Interp *interp, int argc, char *argv[])
{
  int i = 0;
  
  if (argc != 3)
    return TCL_ERROR;
  
  while(i < LAST_HOOK)
    {
      if (!strncmp(onhooks[i].hookname, argv[1], strlen (onhooks[i].hookname)))
	{
	   onhooks[i].funcname = strdup(argv[2]);
	   fprintf(stderr, "%s hooked to function %s\n", argv[1], argv[2]);
	   return TCL_OK;
	 }
      i ++;
    }
  
  fprintf(stderr, "no hooks matching %s\n", argv[1]);
  Tcl_SetResult(interp, "No matching hooks!", TCL_STATIC);
  return TCL_ERROR;
}
/* off hooks  */ 
int Tcl_Off (ClientData cd, Tcl_Interp *interp, int argc, char *argv[])
{
  int i = 0;
  
  if (argc != 2)
    return TCL_ERROR;

  while(i < LAST_HOOK)
    {
      if (!strncmp(onhooks[i].hookname, argv[1], strlen (onhooks[i].hookname)))
	{
	   onhooks[i].funcname = NULL;
	   fprintf(stderr, "%s unhooked\n", argv[1]);
	   return TCL_OK;
	 }
      i ++;
    }
  
  fprintf(stderr, "no hooks matching %s\n", argv[1]);
  Tcl_SetResult(interp, "No matching hooks!", TCL_STATIC);
  return TCL_ERROR;
}

int Tcl_GtkPuts (ClientData cd, Tcl_Interp *interp, int argc, char *argv[])
{
  Message *message;
  if (argc != 2)
    return TCL_ERROR;

  message = message_new(MT_CONSOLE, NULL, NULL);
  message->parts = g_slist_append(message->parts, message_part_new(&colour_white, NULL, NULL, 
								   "TCL:"));
  message->parts = g_slist_append(message->parts, 
				  message_part_new(&colour_white, NULL, NULL, argv[1]));

  messages_write();
  return TCL_OK;
}

int register_tcl(Tcl_Interp *interp)
{
  int rslt;
  /* let's make a few variables global!  */ 
  
  /* well, just this one for now  */ 
  rslt = Tcl_LinkVar(interp, "mynick", (char *)&(connection.nick),
		     TCL_LINK_STRING | TCL_LINK_READ_ONLY);
  if(rslt == TCL_ERROR)
    fprintf(stderr, "%s\n", interp->result);
  
  Tcl_CreateCommand(interp, "send_command", Tcl_send_command, NULL, NULL); 
  Tcl_CreateCommand(interp, "on", Tcl_On, NULL, NULL); 
  Tcl_CreateCommand(interp, "off", Tcl_Off, NULL, NULL); 
  Tcl_CreateCommand(interp, "gtkputs", Tcl_GtkPuts, NULL, NULL); 
  return TCL_OK;
}

int do_hook (int hooknum, int argc, ...)
{
  int i;

  va_list ap;

  if (onhooks[hooknum].funcname == NULL)
    return 0;
  
  if(argc != onhooks[hooknum].argnum)
    return 0;
  
  va_start(ap, argc);
  
  strncpy (cl, onhooks[hooknum].funcname, LINE_LENGTH);
  
  /* iterate through the args and tack them together  */ 
  for (i = 0; i < argc; i ++)
    {
      strncat (cl, " \"", 4);
      strncat (cl, (char *)quotemeta(va_arg(ap, char *)), LINE_LENGTH);
      strncat (cl, "\"", 3);
    }
  
  //fprintf(stderr, "%s\n", cl);  /* debug  */ 

  Tcl_Eval(interp, cl);
  fprintf(stderr, "%s\n", interp->result);
  va_end(ap);
  return 0;
}

char *quotemeta(char *in)
{
  char *pt;
  char *out;
  
  out = (char *)malloc(strlen(in) * 2);
  
  pt = out;
  while (*in != '\0')
    {
      switch (*in)
	{
	case '"':
	  *pt = '\\';
	  pt ++;
	  *pt = '\"';
	  break;
  	case '[':
	  *pt = '\\';
	  pt ++;
	  *pt = '[';	  
	  break;
	case ']':
	  *pt = '\\';
	  pt ++;
	  *pt = ']';	  
	  break;
	default :
	  *pt = *in;
	}
      pt ++;
      in ++;
    }
  *pt = '\0';

  return (out);
}

#endif
