/* Bezerk
 * Copyright (C) 1998 Tony Gale.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef __PREFS_H__
#define __PREFS_H__

typedef struct _Preference {
  char *key;
  char *value;
  char *default_value;
} Preference;

#define PREFS_FILE "preferences"

void preference_save();
char *preference_get(char *key);
char *preference_get_default(char *key);
void preference_set(char *key, char *value);
gint preference_init();

#endif /* __PREFS_H__ */
