/* Bezerk
 * Copyright (C) 1998 Tony Gale.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef __PERSONA_H__
#define __PERSONA_H__

typedef struct _Persona {
  char *nick;
  char *away_nick;
  char *real_name;
} Persona;

typedef struct _PersonaEditData {
  void *user_data;
  GtkWidget *dialog;
  GtkWidget *nick;
  GtkWidget *real_name;
  GtkWidget *away_nick;
  void (*positive_func)(gchar **, void *);
  void (*negative_func)(void *);
} PersonaEditData;

typedef struct _PersonaPrefsData {
  GtkWidget *clist;
  guint changed;
  guint selected_row;
  guint widths[3];
} PersonaPrefsData;

#define PERSONA_FILE "persona"

void persona_save();
Persona *persona_get(gint persona_num);
gint persona_init();
GtkWidget *persona_prefs_create(void **pref_data);
gint persona_prefs_save(void *pref_data);
void persona_prefs_reset(void *pref_data);
void persona_add(char *nick, char *real_name, char *away_nick);
void persona_edit_dialog(void   *user_data,
			 gchar **persona_strs,
			 void  (*positive_func)(gchar **, void *),
			 void  (*negative_func)(void *));

#endif /* __PERSONA_H__ */
