/* Bezerk
 * Copyright (C) 1998 Tony Gale.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */
 
#ifndef __DCC_H__
#define __DCC_H__

#include <sys/stat.h>
#include <unistd.h>
#include <sys/time.h>

#include <gtk/gtk.h>

#include "bezerk.h"
#include "send.h"
#include "dialogs.h"

#define DCC_BUFFLEN 1024

typedef enum {
    DCC_TYPE_SEND,
    DCC_TYPE_GET,
    DCC_TYPE_CHAT,
} DCC_Type;

/* TODO: this should be a union structure for different DCC connection types */
typedef struct _DCC_Connection {

  int type;
  char *nick;
  char *file_name;
  
  char *buff;     /* for chat */
  int recv_count; /* for chat */
  BezMessageWindow *message_window; /* for chat */

  int sd;
  int fd;
  long address; /* for get */
  int port;
  unsigned long size; /* for get */
  unsigned long sent;  /* for send */
  unsigned long acked; /* for send */
  struct stat file_stat; /* for send/get */
  time_t start;

  int tag;
  ProgressData *progress_dialog;
  Connection *connection;
} DCC_Connection;

int dcc_send_send(Connection *connection, char *args);
int dcc_send_chat(Connection *connection, char *to_nick);
void dcc_chat_finish(char *nick);
void dcc_chat_command(char *comm, BezWindow *window);
int process_dcc_request(char *request);
USER_COMMAND(process_dcc_command);

#endif /* __DCC_H__ */
