/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.35
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace be.belgium.eid {

using System;
using System.Runtime.InteropServices;

/// <summary>Abstract base class for Smart card</summary> 
public class BEID_SmartCard : BEID_Card {
  private HandleRef swigCPtr;

  internal BEID_SmartCard(IntPtr cPtr, bool cMemoryOwn) : base(beidlib_dotNetPINVOKE.BEID_SmartCardUpcast(cPtr), cMemoryOwn) {
    swigCPtr = new HandleRef(this, cPtr);
  }

  internal static HandleRef getCPtr(BEID_SmartCard obj) {
    return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
  }

  ~BEID_SmartCard() {
    Dispose();
  }

  public override void Dispose() {
    lock(this) {
      if(swigCPtr.Handle != IntPtr.Zero && swigCMemOwn) {
        swigCMemOwn = false;
        beidlib_dotNetPINVOKE.delete_BEID_SmartCard(swigCPtr);
      }
      swigCPtr = new HandleRef(null, IntPtr.Zero);
      GC.SuppressFinalize(this);
      base.Dispose();
    }
  }

  /// <summary>Select an application from the card.</summary>
  public void selectApplication(BEID_ByteArray applicationId)
  {
    beidlib_dotNetPINVOKE.BEID_SmartCard_selectApplication(swigCPtr, BEID_ByteArray.getCPtr(applicationId));
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
  }

  /// <summary>Send an APDU command to the card and get the result.</summary>
  /// <param name="cmd">is the apdu command </param> 
  /// <param name="pin">is the pin to ask for writing</param>   
  /// <param name="csPinCode">is the code of the pin (it will be asked if needed and not set)</param>
  /// <returns>a BEID_ByteArray containing the result</returns>   
  public virtual BEID_ByteArray sendAPDU(BEID_ByteArray cmd, BEID_Pin pin, string csPinCode)
  {
    BEID_ByteArray ret = new BEID_ByteArray(beidlib_dotNetPINVOKE.BEID_SmartCard_sendAPDU__SWIG_0(swigCPtr, BEID_ByteArray.getCPtr(cmd), BEID_Pin.getCPtr(pin), csPinCode), true);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Send an APDU command to the card and get the result.</summary>
  /// <param name="cmd">is the apdu command </param> 
  /// <param name="pin">is the pin to ask for writing</param>   
  /// <returns>a BEID_ByteArray containing the result</returns>   
  public virtual BEID_ByteArray sendAPDU(BEID_ByteArray cmd, BEID_Pin pin)
  {
    BEID_ByteArray ret = new BEID_ByteArray(beidlib_dotNetPINVOKE.BEID_SmartCard_sendAPDU__SWIG_1(swigCPtr, BEID_ByteArray.getCPtr(cmd), BEID_Pin.getCPtr(pin)), true);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Send an APDU command to the card and get the result.</summary>
  /// <param name="cmd">is the apdu command</param> 
  /// <returns>a BEID_ByteArray containing the result</returns>   
  public override BEID_ByteArray sendAPDU(BEID_ByteArray cmd)
  {
    BEID_ByteArray ret = new BEID_ByteArray(beidlib_dotNetPINVOKE.BEID_SmartCard_sendAPDU__SWIG_2(swigCPtr, BEID_ByteArray.getCPtr(cmd)), true);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary> 
  /// Read a File from the card.
  /// If no pin is passed and a pin is needed by the card, the pin code will be asked anyway.
  /// </summary>
  /// <param name="fileID">is the path of the file</param>   
  /// <param name="arg1">return the file</param> 
  /// <param name="pin">is the pin to ask for reading</param>  
  /// <param name="csPinCode"> is the code of the pin (it will be asked if needed and not set)</param> 
  public virtual int readFile(string fileID, BEID_ByteArray arg1, BEID_Pin pin, string csPinCode)
  {
    int ret = beidlib_dotNetPINVOKE.BEID_SmartCard_readFile__SWIG_0(swigCPtr, fileID, BEID_ByteArray.getCPtr(arg1), BEID_Pin.getCPtr(pin), csPinCode);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary> 
  /// Read a File from the card.
  /// If no pin is passed and a pin is needed by the card, the pin code will be asked anyway.
  /// </summary>
  /// <param name="fileID">is the path of the file</param>   
  /// <param name="arg1">return the file</param> 
  /// <param name="pin">is the pin to ask for reading</param>  
  public virtual int readFile(string fileID, BEID_ByteArray arg1, BEID_Pin pin)
  {
    int ret = beidlib_dotNetPINVOKE.BEID_SmartCard_readFile__SWIG_1(swigCPtr, fileID, BEID_ByteArray.getCPtr(arg1), BEID_Pin.getCPtr(pin));
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary> 
  /// Read a File from the card.
  /// If no pin is passed and a pin is needed by the card, the pin code will be asked anyway.
  /// </summary>
  /// <param name="fileID">is the path of the file</param>   
  /// <param name="arg1">return the file</param> 
  public virtual int readFile(string fileID, BEID_ByteArray arg1)
  {
    int ret = beidlib_dotNetPINVOKE.BEID_SmartCard_readFile__SWIG_2(swigCPtr, fileID, BEID_ByteArray.getCPtr(arg1));
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary> 
  /// Write a file to the card.
  /// Throw BEID_ExCmdNotAllowed exception you're not allowed to write the file.
  /// If no pin is passed and a pin is needed by the card, the pin code will be asked anyway.
  /// </summary>
  /// <param name="fileID">is the path of the file</param>   
  /// <param name="arg1">contents the bytes to write</param>
  /// <param name="pin">pin is the pin to ask for writing</param> 
  /// <param name="csPinCode">is the code of the pin (it will be asked if needed and not set)</param>  
  public virtual bool writeFile(string fileID, BEID_ByteArray arg1, BEID_Pin pin, string csPinCode)
  {
    bool ret = beidlib_dotNetPINVOKE.BEID_SmartCard_writeFile__SWIG_0(swigCPtr, fileID, BEID_ByteArray.getCPtr(arg1), BEID_Pin.getCPtr(pin), csPinCode);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary> 
  /// Write a file to the card.
  /// Throw BEID_ExCmdNotAllowed exception you're not allowed to write the file.
  /// If no pin is passed and a pin is needed by the card, the pin code will be asked anyway.
  /// </summary>
  /// <param name="fileID">is the path of the file</param>   
  /// <param name="arg1">contents the bytes to write</param>
  /// <param name="pin">pin is the pin to ask for writing</param> 
  public virtual bool writeFile(string fileID, BEID_ByteArray arg1, BEID_Pin pin)
  {
    bool ret = beidlib_dotNetPINVOKE.BEID_SmartCard_writeFile__SWIG_1(swigCPtr, fileID, BEID_ByteArray.getCPtr(arg1), BEID_Pin.getCPtr(pin));
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary> 
  /// Write a file to the card.
  /// Throw BEID_ExCmdNotAllowed exception you're not allowed to write the file.
  /// If no pin is passed and a pin is needed by the card, the pin code will be asked anyway.
  /// </summary>
  /// <param name="fileID">is the path of the file</param>   
  /// <param name="arg1">contents the bytes to write</param>
  public override bool writeFile(string fileID, BEID_ByteArray arg1)
  {
    bool ret = beidlib_dotNetPINVOKE.BEID_SmartCard_writeFile__SWIG_2(swigCPtr, fileID, BEID_ByteArray.getCPtr(arg1));
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Return the number of pin on the card.</summary>
  public virtual uint pinCount()
  {
    uint ret = beidlib_dotNetPINVOKE.BEID_SmartCard_pinCount(swigCPtr);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Return an object to access all the pins on the card.</summary>
  public virtual BEID_Pins getPins()
  {
    BEID_Pins ret = new BEID_Pins(beidlib_dotNetPINVOKE.BEID_SmartCard_getPins(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Return the number of certificate on the card.</summary>
  public virtual uint certificateCount()
  {
    uint ret = beidlib_dotNetPINVOKE.BEID_SmartCard_certificateCount(swigCPtr);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Return an object to access all the certificates on the card.</summary>
  public virtual BEID_Certificates getCertificates()
  {
    BEID_Certificates ret = new BEID_Certificates(beidlib_dotNetPINVOKE.BEID_SmartCard_getCertificates(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Return the challenge.</summary>
  /// <param name="bForceNewInit">force a new initialization of the couple challenge/response</param>  
  public virtual BEID_ByteArray getChallenge(bool bForceNewInit)
  {
    BEID_ByteArray ret = new BEID_ByteArray(beidlib_dotNetPINVOKE.BEID_SmartCard_getChallenge__SWIG_0(swigCPtr, bForceNewInit), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Return the challenge.</summary>
  public virtual BEID_ByteArray getChallenge()
  {
    BEID_ByteArray ret = new BEID_ByteArray(beidlib_dotNetPINVOKE.BEID_SmartCard_getChallenge__SWIG_1(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Return the response to the challenge.</summary>
  public virtual BEID_ByteArray getChallengeResponse()
  {
    BEID_ByteArray ret = new BEID_ByteArray(beidlib_dotNetPINVOKE.BEID_SmartCard_getChallengeResponse(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>
  /// Return true if the response of the card to the given challenge is the same as the response expected.
  /// For virtual card (from file), always return false.
  /// </summary>
  /// <param name="challenge">is the challenge to check</param>  
  /// <param name="response">is the response expected from the card</param>  
  public virtual bool verifyChallengeResponse(BEID_ByteArray challenge, BEID_ByteArray response)
  {
    bool ret = beidlib_dotNetPINVOKE.BEID_SmartCard_verifyChallengeResponse(swigCPtr, BEID_ByteArray.getCPtr(challenge), BEID_ByteArray.getCPtr(response));
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

}

}
