//  Basewindow.cc for bbtools.
//
//  Copyright (c) 1998-2000 by John Kennis, jkennis@chello.nl
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// (See the included file COPYING / GPL-2.0)
//

#include "bbppp.hh"
#include "main.hh"

void Usage()
{
	char* usageOptions = {"Options:\n\
	                      -display <display name>     X server to connect to\n\
	                      -c[onfig] <filename>        Alternate config file\n\
	                      -n[obb]                     Fall back on default configuration\n\
	                      -v[ersion]                  Display version number\n\
	                      -h[elp]                     Display this help\n\
	                      -geom[etry] <geometry>      Set geometry of window\n\
	                      -d[ecorated]                Show 'normal' decorated window\n\
	                      -w[ithdrawn]                Place bbtool in the Slit\n\
	                      -s[hape]                    Don't display groundplate\n\
	                      -thru[put]                  Display throughput rate\n\
	                      -o[rient] <v|h>             Display window widgets horizontally or vertically\n\
	                      -com[pact]                  Display buttons in compact style\n\
	                      -notime                     Dont display time window\n\
	                      -nosecs                     Show uptime in old-style hh:mm format\n\n"};

	fprintf(stdout,"\n%s version %s \n",BBTOOL,BBTOOL_VERSION);
	fprintf(stdout,"Usage:\n\
	        %s [options]\n",BBTOOL);
	fprintf(stdout, "%s", usageOptions);
	/*
	fprintf(stdout,"-t[ype] <0|1|2|3>           0: 
	normal size\n");
	fprintf(stdout,"-t[ype] <0|1|2>             0: 
	normal size\n");
	fprintf(stdout,"                            1: 
	64x64 pixels\n");
	fprintf(stdout,"                            2: 
	64 pixels wide\n\n");
	fprintf(stdout,"                            3: 
	shrink to height of blackbox toolbar\n");
	*/
}


int main(int argc,char **argv)
{
	int i;
	struct CMDOPTIONS options;

	options.display_name=NULL;
	options.geometry=NULL;
	options.withdrawn=False;
	options.shape=False;
	options.config_file=NULL;
	options.nobb_config=False;
	options.decorated=False;
	options.thruput=False;
	options.compact  = false;
	options.showtime = true;
	options.showsecs = true;
	options.orient   = horizontal;


	for(i=1;i<argc;i++)
	{
		if ((!strcmp(argv[i],"-display")))
		{
			if(++i==argc)  { Usage(); exit(2); };
			options.display_name=argv[i];
		}
		else if ((!strcmp(argv[i],"-config"))|(!strcmp(argv[i],"-c")))
		{
			if(++i==argc)  { Usage(); exit(2); };
			options.config_file=argv[i];
		}
		else if ((!strcmp(argv[i],"-nobb"))|(!strcmp(argv[i],"-n")))
		{
			options.nobb_config=True;
		}
		else if ((!strcmp(argv[i],"-v")) || (!strcmp(argv[i],"-version")))
		{
			fprintf(stderr," %s version %s\n",BBTOOL,BBTOOL_VERSION);
			exit(2);
		}
		else if ((!strcmp(argv[i],"-h")) || (!strcmp(argv[i],"-help")))
		{
			Usage();
			exit(2);
		}
		else if ((!strcmp(argv[i],"-geometry")) || (!strcmp(argv[i],"-geom")))
		{
			if(++i==argc)  { Usage(); exit(2); };
			options.geometry=argv[i];
		}
		else if ((!strcmp(argv[i],"-withdrawn")) || (!strcmp(argv[i],"-w")))
		{
			options.withdrawn=True;
		}
		else if ((!strcmp(argv[i],"-shape")) || (!strcmp(argv[i],"-s")))
		{
			options.shape=True;
		}
		else if ((!strcmp(argv[i],"-decorated")) || (!strcmp(argv[i],"-d")))
		{
			options.decorated=True;
		}
		else if ((!strcmp(argv[i], "-thruput")) || (!strcmp(argv[i], "-thru")))
		{
			options.thruput = True;
		}
		else if ((!strcmp(argv[i], "-compact")) || (!strcmp(argv[i], "-com")))
		{
			options.compact = true;
		}
		else if (!strcmp(argv[i], "-notime"))
		{
			options.showtime = false;
		}
		else if (!strcmp(argv[i], "-nosecs"))
		{
			options.showsecs = false;
		}
		else if ((!strcmp(argv[i], "-orient")) || (!strcmp(argv[i], "-o")))
		{
			if(++i==argc)  { Usage(); exit(2); };
			if (!strcmp(argv[i], "v"))
				options.orient = vertical;
			else
				options.orient = horizontal;
		}
	}
	ToolWindow bbppp(argc, argv, &options);
}

