// resource.hh for bbpal
//
//  Copyright (c) 1998-1999 John Kennis, jkennis@chello.nl
//
//  this program is free software; you can redistribute it and/or modify
//  it under the terms of the gnu general public license as published by
//  the free software foundation; either version 2 of the license, or
//  (at your option) any later version.
//
//  this program is distributed in the hope that it will be useful,
//  but without any warranty; without even the implied warranty of
//  merchantability or fitness for a particular purpose.  see the
//  gnu general public license for more details.
//
//  you should have received a copy of the gnu general public license
//  along with this program; if not, write to the free software
//  foundation, inc., 675 mass ave, cambridge, ma 02139, usa.
//
// (see the included file copying / gpl-2.0)
//


#ifndef __RESOURCE_HH
#define __RESOURCE_HH

#include "bbpal.hh"
#include "Baseresource.hh"

class BaseResource;

enum {none=0, border=1, texture=2};

struct FRAME {
  int width;
  int height;
  BTexture texture;
  int bevelWidth;
  XFontStruct *font;
};

struct POSITION {
  int x;
  int y;
  int mask;
  bool vertical;
  bool horizontal;
};

struct SIZE {
  unsigned int width;
  unsigned int height;
};

struct REPORT {
  bool auto_raise;
};

struct PAL {
	unsigned int height;
	unsigned int width;
	int delay;
	int numImages;
	char *directory;
	char *name;
};

class Resource : public BaseResource {

public:
  Resource(ToolWindow *);
  ~Resource(void);

  struct FRAME frame;
  struct FRAME label;
  struct POSITION position;
  struct PAL pal;
  struct REPORT report;
  int columns;
  int rows;
  int getFocusStyle(void) { return focus_style; }
  int getDesktopFocusStyle(void) { return desktop_focus_style; }

protected:
  virtual void  LoadBBToolResource(void);

private:
  void Frame(void);
  void SizeAndPosition(void);
  void PalInfo();
  int focus_style;
  int desktop_focus_style;
  void Clean(void);
};
#endif /* __RESOURCE_HH */
