//  bbpal.hh for bbpal.cc
//  Copyright (c) 1999-2000 by Charles Nusbaum, nusbaucj@wooster.edu
//  Base code from John Kennis, jkennis@chello.nl
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// (See the included file COPYING / GPL-2.0)

#ifndef __MAIN_HH
#define __MAIN_HH

#include <X11/xpm.h>
#include "Image.hh"
#include "Basewindow.hh"
#include "resource.hh"
#include "Timer.hh"

#define LEFT_BUTTON 1
#define MIDDLE_BUTTON 2
#define RIGHT_BUTTON 3

class Resource;
class BaseResource;
class Basewindow;

struct PIXMAP {
	Pixmap frame;
	Pixmap label;
};

struct GEOM {
	unsigned int height;
	unsigned int width;
	int x;
	int y;
};
	
typedef struct {
	Pixmap pixmap;
	Pixmap mask;
	XpmAttributes attributes;
} XpmIcon;

class ToolWindow : public Basewindow, TimeoutHandler {
	public:
		ToolWindow(int argc, char **argv, struct CMDOPTIONS *);
		~ToolWindow(void); 

		XGCValues gcv;
		GC frameGC;
		XpmAttributes xpmAttributes;

		Pixmap palpixmap;
		Pixmap palXpmArray[2];
		int palPtr;
		BTimer *timer;
		char currentPal[50];

		Window framewin;
		Window labelwin;
		Resource *resource;

		void MakeWindow(bool);
		void LoadPalArray(void);
		void ChangePal(bool);
		void EventLoop(void);
		void reconfigure(void);
		void Redraw(void);
		void timeout(void);

	protected:
		virtual void process_event(XEvent *);

	private:
		bool lower;
		bool wm_init;
		PIXMAP pixmap;
		GEOM frame;
		GEOM label;
		fd_set rfds;
		char **iargv;
		int iargc;

		void CheckConfig(void);
};

#endif /* __MAIN_HH */
