/* unit-invent.c
 *
 ****************************************************************
 * Copyright (C) 2004, Canonical Limited
 *               Author: Robert Collins
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "hackerlab/vu/reserv.h"
#include "hackerlab/bugs/panic.h"
#include "hackerlab/char/str.h"
#include "libarch/invent.h"
#include "libarch/my.h"


/* typedefs */



/* local methods */



int
main (int argc, char * argv[])
{
    char *invent_data[]={"./foo", "x_f", 
			    "./foo/foo", "x_g", 
			    "./foobar", "x_i", 
			    "./foo/bar", "x_f", 
			    "./baz", "x_y"};
    char *filter_data1[]={"foo"};
    rel_table an_invent;
    rel_table result_invent;
    rel_table paths;

    an_invent = rel_unflatten (10, 2, invent_data);
    paths = rel_unflatten (1, 1, filter_data1);
    result_invent = arch_inventory_included (an_invent, paths);

    invariant (rel_n_records (result_invent) == 3);
    invariant (str_cmp ("./foo", result_invent[0][0]) == 0);
    invariant (str_cmp ("./foo/foo",    result_invent[1][0]) == 0);
    invariant (str_cmp ("./foo/bar",    result_invent[2][0]) == 0);

    /*TODO test n parameter versions, empty table versions */

    return 0;
}

