/* unit-sftp.c
 *
 * vim:smartindent ts=8:sts=2:sta:et:ai:shiftwidth=2
 ****************************************************************
 * Copyright (C) 2005, Canonical Limited
 *               Author: Robert Collins
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "hackerlab/vu/safe-printfmt.h"
#include "hackerlab/bugs/panic.h"
#include "hackerlab/char/str.h"
#include "libarch/pfs.h"



/* typedefs */



/* local methods */



int
main (int argc, char * argv[])
{
  ne_uri parsed_uri;
    /*
typedef struct {
    char *scheme;
    char *host;
    unsigned int port;
    char *path;
    char *authinfo;
} ne_uri;
*/
  invariant_int_cmp (ne_uri_parse ("sftp://user@email.com@host.phwoar/root/path", &parsed_uri), 0);
  invariant_str_cmp (parsed_uri.scheme, "sftp");
  /* detect if they fix it on us */
  invariant_str_cmp (parsed_uri.host, "email.com@host.phwoar");
  arch_uri_heuristics (&parsed_uri);
  invariant_str_cmp (parsed_uri.host, "host.phwoar");
  invariant_str_cmp (parsed_uri.authinfo, "user@email.com");
  invariant_int_cmp (parsed_uri.port, 0);
  ne_uri_free(&parsed_uri);

  return 0;
}

