/* ancestry.h:
 *
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__LIBARCH__ANCESTRY_H
#define INCLUDE__LIBARCH__ANCESTRY_H


#include "libawk/relational.h"
#include "libarch/archive.h"
#include "libarch/project-tree.h"
#include "libarch/patch-id.h"


#define ARCH_ANCESTRY_VERSION_BAZ_1 "arch ancestry version 1"
#define ARCH_ANCESTRY_PATCH_PREFIX "arch:patch:"
#define ARCH_ANCESTRY_PATCH_PARTIAL "PARTIAL"


extern rel_table arch_trace_ancestry (void * context, struct arch_archive * arch, arch_patch_id * patch_id, int merges);
extern rel_table patch_ancestry (void * context, struct arch_project_tree *optional_tree, arch_patch_id * patch_id, int minimum_depth);
extern void ancestry_write (rel_table ancestry, int fd, int maxmimum_length);
extern void ancestry_upload_patch (struct arch_archive * arch, arch_patch_id * patch_id, int max_depth);
extern arch_patch_id * arch_patch_ancestor (void * context, arch_patch_id * patch_id, int cached_only);
extern void arch_ancestry_note_ancestor (arch_patch_id * patch_id, t_uchar const *ancestor);
#endif  /* INCLUDE__LIBARCH__ANCESTRY_H */


/* tag: Tom Lord Sat Jan  5 15:26:10 2002 (ancestry.h)
 */
