/* unit-patch-id.c
 *
 * vim:smartindent ts=8:sts=2:sta:et:ai:shiftwidth=2
 ****************************************************************
 * Copyright (C) 2005, Canonical Limited
 *               Author: Robert Collins
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "hackerlab/vu/safe-printfmt.h"
#include "hackerlab/bugs/panic.h"
#include "hackerlab/char/str.h"
#include "libarch/patch-id.h"



/* typedefs */



/* local methods */
/* FIXME: move to hackerlab ? */
static void
invariant_str_cmp(t_uchar const *left, t_uchar const *right)
{
    if (str_cmp (left, right))
	safe_printfmt (2, "assertion failed: '%s' != '%s'\n", left, right);
}

static void 
check_patch_id_init_finalise (void)
{
  arch_patch_id aPatch;

  arch_patch_id_init (&aPatch, "foo@example.com/jon--belushi--1.2--patch-324");
  invariant_str_cmp (aPatch.patch_id, "foo@example.com/jon--belushi--1.2--patch-324");
  invariant (!aPatch.archive);
  invariant (!aPatch.version);
  invariant (!aPatch.revision);
  invariant (!aPatch.patchlevel);
  arch_patch_id_archive (&aPatch);
  arch_patch_id_revision (&aPatch);
  arch_patch_id_version (&aPatch);
  arch_patch_id_patchlevel (&aPatch);
  
  invariant_str_cmp (aPatch.patch_id, "foo@example.com/jon--belushi--1.2--patch-324");
  invariant (!!aPatch.archive);
  invariant (!!aPatch.version);
  invariant (!!aPatch.revision);
  invariant (!!aPatch.patchlevel);
  
  arch_patch_id_finalise (&aPatch);
  invariant (!aPatch.patch_id);
  invariant (!aPatch.archive);
  invariant (!aPatch.version);
  invariant (!aPatch.revision);
  invariant (!aPatch.patchlevel);

  arch_patch_id_init_archive (&aPatch, "foo@example.com", "jon--belushi--1.2--patch-324");
  invariant_str_cmp (aPatch.patch_id, "foo@example.com/jon--belushi--1.2--patch-324");
  arch_patch_id_finalise (&aPatch);
}

static void 
check_patch_id_accessors (void)
{
  arch_patch_id aPatch;

  arch_patch_id_init (&aPatch, "foo@example.com/jon--belushi--1.2--patch-123");
  invariant_str_cmp (aPatch.patch_id, "foo@example.com/jon--belushi--1.2--patch-123");
  invariant_str_cmp (arch_patch_id_archive (&aPatch), "foo@example.com");
  invariant_str_cmp (arch_patch_id_revision (&aPatch), "jon--belushi--1.2--patch-123");
  invariant_str_cmp (arch_patch_id_version (&aPatch), "jon--belushi--1.2");
  invariant_str_cmp (arch_patch_id_patchlevel (&aPatch), "patch-123");
  
  arch_patch_id_finalise (&aPatch);
}




int
main (int argc, char * argv[])
{
  check_patch_id_init_finalise();
  check_patch_id_accessors();
  return 0;
}

