# Copyright (C) 1999, 2000 Jay Beale
# Licensed under the GNU General Public License

package Bastille::Logging;
use lib "/usr/lib";

use Bastille::API;


#######################################################################
##                               Logging                             ##
#######################################################################

#&ConfigureAutomatedLogWatcher
&ConfigureAdditionalLogging;
&AddProcessAccounting;           # capveg 12/99
#&AddSecurityChecks;

####&ConfigureAutomatedLogWatcher;
####
#### Anyone want to do this?
####


sub ConfigureAdditionalLogging {

    if (&getGlobalConfig("Logging","morelogging") eq "Y") {
	&ActionLog("# sub ConfigureAdditionalLogging\n");

	# BUG: setting up remote logging should be a separate function, 
	#      such that we can configure it even when we aren't adding
	#      logs to the system.
	my $logging_host=&getGlobalConfig("Logging","remotelog_host");

	# Add two more logging files to RedHat's default scheme and log 
	# lots of data to TTY 7 and 8
	 

        # We add additional logging files:
        #/var/log/kernel       --    kernel messages
        #/var/log/syslog       --    messages of severity \"warning\" and 
	#                            \"error\" 
	#/var/log/loginlog     --    all logins...

	#
        # Also configure the 7th and 8th TTYs for more logging.     

	my $var_log_syslog_lines= <<END_SYSLOG;
# Log warning and errors to the new file /var/log/syslog
*.warn;*.err\t/var/log/syslog

END_SYSLOG

        my $var_log_kernel_lines= <<END_KERNEL;
# Log all kernel messages to the new file /var/log/kernel
kern.*\t/var/log/kernel

END_KERNEL

    my $var_log_loginlog_lines = <<END_LOGINLOG;
# Log all logins to /var/log/loginlog
auth.*;user.*;daemon.none\t/var/log/loginlog

END_LOGINLOG

    my $tty_log_lines= <<END_TTY_LOG;
# Log additional data to the Alt-F7 and Alt-F8 screens (Pseudo TTY 7 and 8)

*.info;mail.none;authpriv.none\t/dev/tty7
authpriv.*\t/dev/tty7
*.warn;*.err\t/dev/tty7
kern.*\t/dev/tty7
mail.*\t/dev/tty8

END_TTY_LOG

	&B_append_line("/etc/syslog.conf","ADDITIONS","############ BASTILLE ADDITIONS BELOW : ################# \n");
	
	&B_append_line("/etc/syslog.conf",'\/var\/log\/syslog',$var_log_syslog_lines);
	&B_append_line("/etc/syslog.conf",'\/var\/log\/kernel',$var_log_kernel_lines);
	&B_append_line("/etc/syslog.conf",'\/var\/log\/loginlog',$var_log_loginlog_lines);
	&B_append_line("/etc/syslog.conf",'\/dev\/tty7',$tty_log_lines);
	&B_append_line("/etc/syslog.conf",'\/dev\/tty12',"*.*\t/dev/tty12\n");

	if ($logging_host) {
	    &B_append_line("/etc/syslog.conf","\\\@$logging_host","*.warn;*.err\t\@$logging_host\nauthpriv.*;auth.*\t\@$logging_host\n");
	}

	&B_append_line("/etc/syslog.conf","BASTILLE ADDITIONS CONCLUDED","########## BASTILLE ADDITIONS CONCLUDED : ###############\n");

	&B_create_file("/var/log/syslog");
	&B_create_file("/var/log/kernel");
	&B_create_file("/var/log/loginlog");

	#
	# Configure log rotation for the new log files:
	#

	my $rotation_lines = <<END_NEW_ROT;
   
/var/log/kernel {
    postrotate
	/usr/bin/killall -HUP syslogd
    endscript
}
   
/var/log/syslog {
    postrotate
	/usr/bin/killall -HUP syslogd
    endscript
}

/var/log/loginlog {
    postrotate
	/usr/bin/killall -HUP syslogd
    endscript
}
END_NEW_ROT


        &B_append_line("/etc/logrotate.d/syslog",'\bloginlog\b',$rotation_lines);
    
   }
}


####AddProcessAccouting;
####
#### Turn on BSD style process accounting
####
#### Idea and Methodology contributed by "capveg@cs.umd.edu"
####

sub AddProcessAccounting { 

   &ActionLog("# sub AddProcessAccounting\n");

   if ( (&getGlobalConfig("Logging","pacct") eq "Y") and (&getGlobal('BIN','accton')) ){

	   if ( $distro !~ "^DB" ) {
			  

       # Turn on accounting via the accton command

       &B_append_line(&getGlobal('DIR', "rcd") . "/rc.local","pacct","# Process accounting activated by Bastille \n" . &getGlobal('BIN',"accton") . " " . &getGlobal('DIR', "log") . "/pacct\n");

       &B_create_file(&getGlobal('DIR', "log") . "/pacct");
       &B_chmod (0600,&getGlobal('DIR', "log") . "/pacct");

       #
       # Set the log rotation for process accounting
       #
       my $pacct_rotate_lines = <<END_PACCT_ROT;

# Added by Bastille Linux
# default to rotation schedule set in /etc/logrotate.conf
&getGlobal('DIR', "log")/pacct {
      postrotate
              &getGlobal('BIN',"accton") $GLOBAL_LOG/pacct
      endscript
}

END_PACCT_ROT

       &B_create_file("/etc/logrotate.d/pacct");
       &B_append_line("/etc/logrotate.d/pacct","Bastille",$pacct_rotate_lines);

	      } else {
		      &ErrorLog("# Process Accounting is started automatically in Debian\nwhen the 'acct' package is installed and Bastille cannot (yet) enable it automatically.\n");
		      # TODO (jfs)
		      # Warning: on Debian the accounting is started automatically 
		      # when the 'acct' package is installed. An can be enabled/disabled
		      # in the /etc/init.d/acct script START_ACCT variable (0 or 1)

	      }
       
      }                               
}

1;
