# Copyright (C) 1999, 2000 Jay Beale
# Licensed under the GNU General Public License

package Bastille::Sendmail;
use lib "/usr/lib";

use Bastille::API;

## TO DO: Generalize Sendmail.pm to other distros...
##


#######################################################################
##                               Sendmail                            ##
#######################################################################

# It is very important to note that each of these subroutines represent
# an OPTIONAL configuration mode.  Different options work for different
# types of machines.  A web server may only need to process outgoing
# mail to other systems and internal only mail, say, to process
# error messages going out via email.  A corporate mail server, on the
# other hand, has other needs.

&ResistUsernameRecon;
&RunSendmailViaCron;
#&InstallFetchmail;
#&InstallPostfix;
&DeactivateDaemonMode;
&RestrictRelaying;


## TODO: Remove Redhat/mandrake... dependence below: these next two only work on redhat-like things...

sub DeactivateDaemonMode {

    if (&getGlobalConfig("Sendmail","sendmaildaemon") eq "Y") {
	&ActionLog("# sub DeactiveDaemonMode\n");
	unless ( $GLOBAL_DISTRO =~ "^HP-UX") {
	    if(&getGlobalConfig("Sendmail","sendmailcron") ne "Y"){
		&B_chkconfig_off("sendmail");
	    }
	}
	else {
	    &B_ch_rc ('SENDMAIL_SERVER',&getGlobal('FILE', 'sysconfig_sendmail'));
	}
    }
}

sub RunSendmailViaCron {

    if ( &getGlobalConfig("Sendmail","sendmailcron") eq "Y" ) {
	&ActionLog("# RunSendmailViaCron\n");
	if($GLOBAL_DISTRO =~ "^HP-UX"){
	    unless ( -e &getGlobal('FILE', "root_cron") ) {
		&B_create_file(&getGlobal('FILE', "root_cron"));
	    }

	    # adding an entry to the cron if one does not already exist.
	    &B_System(&getGlobal('BIN','crontab') . " " .&getGlobal('FILE','root_cron'), 
		      &getGlobal('BIN','crontab') . " " .&getGlobal('FILE','root_cron'));

	    &B_append_line(&getGlobal('FILE','root_cron'), &getGlobal('BIN','sendmail') . " -q",
			    "0,15,30,45 * * * * " . &getGlobal('BIN','sendmail') . " -q\n");

	    &B_System(&getGlobal('BIN','crontab') . " " .&getGlobal('FILE','root_cron'), 
		      &getGlobal('BIN','crontab') . " " .&getGlobal('FILE','root_cron'));

	}
	else{
	    &B_replace_line(&getGlobal('FILE',"sysconfig_sendmail"),"DAEMON=yes","DAEMON=no\n");
	    &B_replace_line(&getGlobal('FILE',"sysconfig_sendmail"),"QUEUE=","QUEUE=15m\n");
	}

    }

}

sub InstallFetchmail {
   #&ActionLog("# sub InstallFetchmail\n");
#
# Offer to install fetchmail...  DOES SOMEONE WANT TO DO THIS?
#
}

sub InstallPostfix {
   #&ActionLog("# sub InstallPostfix\n");
#
# Offer to switch to postfix...  DOES SOMEONE WANT TO DO THIS?
#

}


sub ResistUsernameRecon {

    if (&getGlobalConfig("Sendmail","vrfyexpn") eq "Y") {
	# Disable sendmail's vrfy and expn commands
	&ActionLog("# sub ResistUsernameRecon\n");
	unless ( $GLOBAL_DISTRO =~ "^HP-UX") {
	    &B_replace_line(&getGlobal('FILE', "sendmail.cf"),"^O Privacy","O PrivacyOptions=goaway\n");
	}
	else {
	    &B_hash_uncomment_line(&getGlobal('FILE', "sendmail.cf"),"noexpn");
	    &B_hash_uncomment_line(&getGlobal('FILE', "sendmail.cf"),"novrfy");
	    if (&getGlobalConfig("Sendmail","sendmaildaemon") ne "Y") {
		&B_System (&getGlobal('FILE', "sysconfig_sendmail") . ' stop', &getGlobal('FILE', "sysconfig_sendmail") . ' start');
		&B_System (&getGlobal('FILE', "sysconfig_sendmail") . ' start', &getGlobal('FILE', "sysconfig_sendmail") . ' stop');
	    }
	}
    }
}

sub RestrictRelaying {
   &ActionLog("# sub RestrictRelaying\n");
   # Restrict relaying

   ## RH 6.0 already has this done -- remember it for other distros.
   
   #### Is there anything additional we should do here?
}



1;

