# Copyright (C) 1999, 2000, 2001 Jay Beale
# Copyright (C) 2001 Hewlett Packard
# Licensed under the GNU General Public License

# Bastille 1.3.x
# $Source: /cvsroot/bastille-linux/dev/working_tree/Bastille/Bastille/SecureInetd.pm,v $ 
# Modified by: $Author: jay $
# $Date: 2002/01/08 18:22:04 $
# $Revision: 1.35 $

package Bastille::SecureInetd;
use lib "/usr/lib";

use Bastille::API;


#### TO DO:  Completely change what we do here...  DonW's suggestion?



#######################################################################
##                    inetd / TCP Wrappers Configuration             ##
#######################################################################

#&ModifyInetdconf;
&SetWrappersDefaultDeny;
&DeactivateTelnet;
&DeactivateFTP;
&CreateBanners;
&ServiceAudit;

sub SetWrappersDefaultDeny {

    # If they've got TCP Wrappers and want this, set a default deny
    # policy in hosts.allow.  Intent here is to get the safe_finger
    # stuff in again.

    if (&getGlobalConfig("SecureInetd","tcpd_default_deny") eq "Y") {
	
	&ActionLog("# sub SetWrappersDefaultDeny\n");

	# add a line to the end of /etc/hosts.allow
	my $line = '# Bastille: default deny
# no safe_finger for in.fingerd (prevent loops)
in.fingerd : ALL : DENY
# but everything else is denied & reported with safe_finger
ALL : ALL : spawn (/usr/sbin/safe_finger -l @%h | /bin/mail -s "Port Denial noted %d-%h" root) & : DENY
';
	if (! -e ($GLOBAL_PREFIX.&getGlobal('FILE', "hosts.allow")) ) {
		# make a default hosts.allow file
		&B_place("/hosts.allow",&getGlobal('FILE', "hosts.allow"));
		&B_chmod(0644,&getGlobal('FILE', "hosts.allow"));
	}
	&B_append_line(&getGlobal('FILE', "hosts.allow"),'^\s*ALL\s*:\s*ALL\b',$line);
    }
}

sub DeactivateTelnet {
    if ( &getGlobalConfig("SecureInetd","deactivate_telnet") eq "Y" ) {
	&ActionLog("# sub deactivate_telnet\n");
	if (( -e &getGlobal('DIR', "xinetd.d") . "/telnet") && (&getGlobal('DIR', "xinetd.d") ne "")) {
	    # If telnet is run via xinetd, then add/modify the disable line
	    &B_replace_line(&getGlobal('DIR', "xinetd.d") . '/telnet','disable\s*=',"\tdisable\t\t= yes\n");
	    &B_insert_line(&getGlobal('DIR', "xinetd.d") . '/telnet','disable\s*=',"\tdisable\t\t= yes\n",'server\s*=');

# If telnet is run via xinetd, then delete the file	    
#	    &B_delete_file(&getGlobal('DIR', "xinetd.d") . "/telnet");
	}
	elsif ( -e $GLOBAL_PREFIX . &getGlobal('FILE', "inetd.conf") ) {
	    if ( $GLOBAL_DISTRO =~ "^HP-UX" ){ #send SIGHUP to inetd to re-read inetd.conf
		&B_System(&getGlobal('BIN',"inetd") . " -c", &getGlobal('BIN',"inetd") . " -c");
	    }
	    &B_hash_comment_line( &getGlobal('FILE', "inetd.conf"),"^\s*telnet");
	    if ( $GLOBAL_DISTRO =~ "^HP-UX" ){
		&B_System(&getGlobal('BIN',"inetd"). " -c",  &getGlobal('BIN',"inetd") . " -c");
	    }# Two B_System calls, one during execution, one during undo... happens
	     # Must hapen after file modifications in redo and do.
	}
    }
}

sub DeactivateFTP {
    if ( &getGlobalConfig("SecureInetd","deactivate_ftp") eq "Y" ) {
	&ActionLog("# sub deactivate_ftp\n");
	if (( -e &getGlobal('DIR', "xinetd.d") . "/ftp") && (&getGlobal('DIR', "xinetd.d") ne "" )) {
	    # If ftp is run via xinetd, then add/modify the disable line
	     &B_replace_line(&getGlobal('DIR', "xinetd.d") . '/ftp','disable\s*=',"disable=yes\n");
	    &B_insert_line(&getGlobal('DIR', "xinetd.d") . '/ftp','disable\s*=',"disable=yes\n",'server\s*=');

	    # If ftp is run via xinetd, then delete the file
	    # &B_delete_file(&getGlobal('DIR', "xinetd.d") . "/ftp");
	}
	elsif ( -e $GLOBAL_PREFIX . &getGlobal('FILE', "inetd.conf") ) {
	    if ( $GLOBAL_DISTRO =~ "^HP-UX" ){ #send SIGHUP to inetd to re-read inetd.conf
		&B_System( &getGlobal('BIN',"inetd") . " -c", &getGlobal('BIN',"inetd") . " -c");
	    }
	    &B_hash_comment_line( &getGlobal('FILE', "inetd.conf"),"^\s*ftp");
	    if ( $GLOBAL_DISTRO =~ "^HP-UX" ){
		&B_System( &getGlobal('BIN',"inetd"). " -c",  &getGlobal('BIN',"inetd") . " -c");
	    }
	}
    }
}




sub ModifyInetdconf {

# uncomment pop3,imap,tftpd and in.bootpd ; the latter two are used
# specifically as "booby traps" to better log scans
# further, comment the (default non-tcp wrapped) linuxconf

   if (&getGlobalConfig("SecureInetd","modifyinetd") eq "Y") {

       &ActionLog("# sub ModifyInetdconf\n");
 
       &B_hash_uncomment_line (&getGlobal('FILE', "inetd.conf"),"^pop-3");
       &B_hash_uncomment_line (&getGlobal('FILE', "inetd.conf"),"^imap");
       &B_hash_uncomment_line (&getGlobal('FILE', "inetd.conf"),"^tftp");
       &B_hash_uncomment_line (&getGlobal('FILE', "inetd.conf"),"^bootpd");
       &B_hash_comment_line (&getGlobal('FILE', "inetd.conf"),"linuxconf");

       # Default ssh: allow all IP's.
       my $ssh_allowed_hosts="ALL";

       if (&getGlobalConfig("SecureInetd","limit_ssh") eq "Y") {

	   # If the range isn't written, just set it to ALL
	   unless (&getGlobalConfig("SecureInetd","limit_ssh_range")) {
	       $ssh_allowed_hosts="ALL";
	   }
	   else {

	       # Add localhost to the ssh range if it's not there...
	       $ssh_allowed_hosts=&getGlobalConfig("SecureInetd","limit_ssh_range");
	       unless ($ssh_allowed_hosts =~ /127\.0\.0\.1/) {
		   $ssh_allowed_hosts="$ssh_allowed_hosts 127.0.0.1";
	       }
	   }
      }

       # Replace entire hosts.allow file

       my $hosts_allow_file = <<END_HOSTS_ALLOW;
#
# hosts.allow   This file describes the names of the hosts which are
#               allowed to use the local INET services, as decided
#               by the '/usr/sbin/tcpd' server.
#

# Bastille modifications made below...
	    
# Let everyone ssh here.
sshd: $ssh_allowed_hosts : ALLOW

# TELNET: Please be advised that telnet is a rather dangerous protocol.
#         All usernames/passwords used in remote sessions via telnet can
#         be seen by many other computers between them.  In fact, most
#         ethernet configurations allow every other computer on your 
#         local area network to see the entire session, passwords and all.
#         Further, there are utilities (like Hunt) in wide use that allow
#         one of these hosts to take over your telnet session.
#         
#         There is a much safer facility that allows for remote logins,
#         which is installed on your box, called ssh.  To use it, type:
#
#                 ssh username\@targethost 
#
#         Please don't uncomment the line below...

#in.telnetd: ALL : banners /etc/banners : ALLOW

# FTP:    Please be advised that ftp is a rather dangerous protocol.
#         All usernames/passwords used in remote sessions via ftp can
#         be seen by many other computers between them.  In fact, most
#         ethernet configurations allow every other computer on your 
#         local area network to see the entire session, passwords and all.
#
#         There is a much safer facility that allows for remote copies,
#         which is installed on your box, called scp.  To use it, read a
#         bit by typing 
#
#                       man scp
#
#         In essence, it works much like "cp," but with remote sources/targets.
#         For example,  scp jay\@zark.umuc.edu:/etc/hosts /etc/hosts
#
#
#         Please don't uncomment the line below...

#in.ftpd: ALL : banners /etc/banners : ALLOW

# POP3/:   You can allow pop3/imapd, but it is highly recommended that you
# IMAPD:   look into a secure version that does not transmit names/passwords
#          in cleartext.  Please consider doing this before you uncomment the
#          lines below:

#ipop3d: ALL : ALLOW
#imapd:  ALL : ALLOW


# Set a default deny stance with back finger "booby trap" (Venema's term)
# Allow finger to prevent deadly finger wars, whereby another booby trapped
# box answers our finger with its own, spawning another from us, ad infinitum

in.fingerd: ALL : ALLOW

ALL : ALL : spawn (/usr/sbin/safe_finger -l @%h | /bin/mail -s "Port Denial noted %d-%h" root) & : DENY

END_HOSTS_ALLOW

       &B_blank_file ("/etc/hosts.allow");
       &B_append_line ("/etc/hosts.allow","Bastille",$hosts_allow_file);


   }
}

sub CreateBanners {
    my $tcpwrappers=0;
    if (&getGlobalConfig("SecureInetd","banners") eq "Y") {
#	my $distro = &GetDistro; # This information is already available, so not needed
	&ActionLog("# sub CreateBanners\n");
	if ( (($GLOBAL_DISTRO =~ /^RH/) or ($GLOBAL_DISTRO =~ /^MN/)) 
             and ( -e ($GLOBAL_PREFIX . &getGlobal('FILE', "tcpd")) )
             and ( -e ($GLOBAL_PREFIX . &getGlobal('FILE', "banners_makefile"))) ) {
	    
	    # Create banners for telnet/ftp...

	    my $banners_makefile =  &getGlobal('FILE', "banners_makefile");
	    &B_create_dir ("/etc/banners");
	    &B_chmod (0744,"/etc/banners");

	    unless ($GLOBAL_LOGONLY) {
		&B_cp($banners_makefile,"/etc/banners/Makefile");
	    }

	    &B_create_file("/etc/banners/prototype");
	    $tcpwrappers=1;
	}


        my $owner = &getGlobalConfig("SecureInetd", "owner");
	my $banner_line = <<ENDBANNER;

***************************************************************************
                            NOTICE TO USERS


This computer system is the private property of $owner, whether 
individual, corporate or government.  It is for authorized use only. 
Users (authorized or unauthorized) have no explicit or implicit 
expectation of privacy.  

Any or all uses of this system and all files on this system may be 
intercepted, monitored, recorded, copied, audited, inspected, and 
disclosed to your employer, to authorized site, government, and law 
enforcement personnel, as well as authorized officials of government 
agencies, both domestic and foreign.  

By using this system, the user consents to such interception, monitoring, 
recording, copying, auditing, inspection, and disclosure at the 
discretion of such personnel or officials.  Unauthorized or improper use 
of this system may result in civil and criminal penalties and 
administrative or disciplinary action, as appropriate. By continuing to 
use this system you indicate your awareness of and consent to these terms 
and conditions of use. LOG OFF IMMEDIATELY if you do not agree to the 
conditions stated in this warning.  

****************************************************************************

ENDBANNER
    
    if ($tcpwrappers == 1) {
	&B_append_line("/etc/banners/prototype","NOTICE",$banner_line);
    }
	
    unless ( -e &getGlobal('FILE', "issue") ) {
	&B_create_file(&getGlobal('FILE', "issue"));
    }
    &B_blank_file(&getGlobal('FILE', "issue"),'a$b');
    &B_append_line(&getGlobal('FILE', "issue"),"NOTICE",$banner_line);
    if($GLOBAL_DISTRO =~ "^HP-UX"){
	&B_System(&getGlobal('BIN',"inetd") . " -c", &getGlobal('BIN',"inetd") . " -c");
	if(open INETD, "< " . &getGlobal('FILE',"inetd.conf")){
	    while(my $line = <INETD>){
		chomp $line;
		if($line =~ /\s+rlogind\s*$|\s+rlogind\s*\-.*$/){
		    &B_replace_line(&getGlobal('FILE',"inetd.conf"),"$line","$line -B " . &getGlobal('FILE',"issue") . "\n");
		}
		elsif($line =~ /\s+telnetd\s*|\s+telnetd\s*\-.*$/){
		    &B_replace_line(&getGlobal('FILE',"inetd.conf"),"$line","$line -b " . &getGlobal('FILE',"issue") . "\n");
		}
	    }
	    close INETD;
	}
	else{
	    &ErrorLog("ERROR: Bastille could not open " . &getGlobal('FILE',"inetd.conf") ."\n");
	}
	&B_System(&getGlobal('BIN',"inetd") . " -c", &getGlobal('BIN',"inetd") . " -c");
	
    }
  }
}

sub ServiceAudit {
    if (&getGlobalConfig("SecureInetd","inetd_general") eq "Y") {
	&ActionLog("# sub ServiceAudit\n");
	my $inetd_text = 
	   "Disable all of the unneeded services in /etc/inetd.conf.  You can\n" .
           "do this by putting a \"#\" at the beginning of the line \n" .
	   "corresponding to each unnecessary service and running \"inetd -c\".\n";
	&B_TODO($inetd_text);
    }
}

1;







