//
// File:        Ensures.java
// Package:     gov.llnl.babel.ast
// Copyright:   (c) 2006 Lawrence Livermore National Security, LLC
// Release:     $Name$
// Revision:    @(#) $Revision: 6171 $
// Date:        $Date: 2007-10-08 16:39:28 -0700 (Mon, 08 Oct 2007) $
// Description: Hold an ensures assertion list
// 

package gov.llnl.babel.ast;
import gov.llnl.babel.visitor.Visitor;
import gov.llnl.babel.parsers.sidl2.ParseTreeNode;

import java.util.List;

public class Ensures extends ASTNode {
  List d_ensureExprs = null;

  public Ensures(ParseTreeNode node, ASTNode parent)
  {
    super(node, parent);
  }

  public Ensures()
  {
    super(null, null);
  }

  public List getEnsureExprs() { 
    return d_ensureExprs;
  }

  public void setEnsureExprs(List ensureExprs)
  {
    d_ensureExprs = ensureExprs;
  }

  public Object accept(Visitor v, Object data)
  {
    return v.visitEnsures(this, data);
  }
}
