<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    site-webpage.php                                        */
/* Author:      Paul Waite                                              */
/* Description: Included by every Site Webpage.                         */
/*                                                                      */
/* ******************************************************************** */
/**
* Include the Axyl plugin content renderers.
* This included source file contains the standard Axyl functions
* which render content for template plugin areas..
*/
include_once("axyl-plugins.php");

// -----------------------------------------------------------------------
// Some useful debugging..
$_theme = $theme != "" ? $theme : "default";
$_mode = isset($RESPONSE->microsite_detected)
          ? "microsite: $RESPONSE->microsite_detected"
          : "standard website";
debugbr("theme: $_theme", DBG_DEBUG);
debugbr("mode: $_mode", DBG_DEBUG);


// -----------------------------------------------------------------------
// Generic window opener..
$RESPONSE->head->add_script(
      "var newwin = null;\n"
    . "function windowopen(winurl,winname,winparams) {\n"
    . "  newwin = window.open(winurl,winname,winparams);\n"
    . "}\n"
    );

// -----------------------------------------------------------------------
// MAIN MENU and LOGIN
// Global plugin behaviour across the website. This is skipped for
// microsites, which will be plugging in their own content..
if ($RESPONSE->microsite_detected == "") {
  // Global site plugin requirements
  $RESPONSE->plugin("MAIN_MENU", "main_menu()");
  $RESPONSE->plugin("MEMBER_LOGIN", "member_login()");
}

// -----------------------------------------------------------------------
// Site search
// Checks for/executes any search activity. If there is a search then
// this will not return. This module will render the search form in the
// place of the <!--SITE_SEARCH--> plugin location.
// Note: for microsites, this behaves slightly differently and only
// defines the search content-plugin functions..
include_once("axyl-search.php");

// -----------------------------------------------------------------------
?>