/** *********************************************************************
 * Copyright (C) 2003 Catalyst IT                                       *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to:                           *
 *   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    *
 *   Boston, MA  02111-1307  USA                                        *
 ************************************************************************/
package nz.net.catalyst.lucene.server;

import java.util.HashMap;
import java.util.Map;

import nz.net.catalyst.Util;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

/**
 * Manages a pool of Lucene Standard Analyzers.  Since Standard
 * Analyzers are only differentiated by their stop-lists, a table of
 * Analyzers by stop-list is maintained.
 */

public class AnalyzerPool implements IPackage, Constants
{
  /**
   * This is the pool of all Analyzer objects we've created. <p>
   *
   * Map key is StopList, value is Analyzer.
   */
  private static final Map pool = new HashMap();

  /**
   * Get an Analyzer incorporating the supplied stop words.
   */

  public static synchronized Analyzer get(String[] stopwords)
  {
    StopList stopList = StopList.create(stopwords);

    Analyzer analyzer = (Analyzer)pool.get(stopList);

    if (analyzer != null)
      return analyzer;

    if (stopwords.length == 0)
      analyzer = new StandardAnalyzer();  // Default stop words -- crap
    else
      analyzer = new StandardAnalyzer(stopList.getStopWords());

    pool.put(stopList, analyzer);
    return analyzer;
  }

  /**
   * Get an Analyzer incorporating the supplied stop words.
   */

  public static Analyzer get(String stopwords)
  {
    return get(Util.split(stopwords == null ? "" : stopwords));
  }
}
