/*
 * Decompiled with CFR 0.152.
 */
package com.holub.asynch;

import com.holub.asynch.Blocking_queue;
import com.holub.tools.Command;

public class Thread_pool
extends ThreadGroup {
    private final Blocking_queue pool = new Blocking_queue();
    private int maximum_size;
    private int pool_size;
    private boolean has_closed = false;
    private static int group_number = 0;
    private static int thread_id = 0;

    public Thread_pool(int initial_thread_count, int maximum_thread_count) {
        super("Thread_pool" + group_number++);
        this.maximum_size = maximum_thread_count > 0 ? maximum_thread_count : Integer.MAX_VALUE;
        int i = this.pool_size = Math.min(initial_thread_count, this.maximum_size);
        while (--i >= 0) {
            new Pooled_thread().start();
        }
    }

    public Thread_pool() {
        super("Thread_pool" + group_number++);
        this.maximum_size = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void execute(Object action) throws Closed {
        if (this.has_closed) {
            throw new Closed();
        }
        if (this.pool_size < this.maximum_size && this.pool.waiting_threads() == 0) {
            Blocking_queue blocking_queue = this.pool;
            synchronized (blocking_queue) {
                if (this.pool_size < this.maximum_size && this.pool.waiting_threads() == 0) {
                    ++this.pool_size;
                    new Pooled_thread().start();
                }
                this.pool.enqueue(action);
            }
        } else {
            this.pool.enqueue(action);
        }
    }

    public final synchronized void execute(final Command action, final Object argument) throws Closed {
        this.execute(new Runnable(){

            public void run() {
                action.execute(argument);
            }
        });
    }

    public synchronized void close() {
        this.has_closed = true;
        this.pool.close();
    }

    private class Pooled_thread
    extends Thread {
        public Pooled_thread() {
            StringBuilder stringBuilder = new StringBuilder("T");
            int n = thread_id;
            thread_id = n + 1;
            super((ThreadGroup)Thread_pool.this, stringBuilder.append(n).toString());
        }

        public void run() {
            try {
                while (!Thread_pool.this.has_closed) {
                    ((Runnable)Thread_pool.this.pool.dequeue()).run();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Blocking_queue.Closed closed) {
                // empty catch block
            }
        }
    }

    public class Closed
    extends RuntimeException {
        static final long serialVersionUID = 0L;

        Closed() {
            super("Tried to execute operation on a closed Thread_pool");
        }
    }

    public static class Test {
        private static Thread_pool pool = new Thread_pool(10, 10);

        public static void main(String[] args) {
            Test test_bed = new Test();
            test_bed.fire_runnable("hello");
            pool.execute(new Command(){

                public void execute(Object argument) {
                    System.out.println("Starting " + argument);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.out.println("Stoping " + argument);
                }
            }, "world");
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            pool.close();
        }

        private void fire_runnable(final String id) {
            pool.execute(new Runnable(){

                public void run() {
                    System.out.println("Starting " + id);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.out.println("Stoping " + id);
                }
            });
        }
    }
}

