/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.net.Socket;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import nz.net.catalyst.IPackage;
import nz.net.catalyst.Pair;

public final class Util
implements IPackage {
    public static final int DEFAULT_CLEAN_LENGTH = 80;
    private static final BitSet DEFAULT_PLAIN = new BitSet(128);
    private static final Map PLAIN_CACHE;
    public static final String DEFAULT_DELIMITERS = " \r\n\t\f,";

    static {
        int i = 32;
        while (i <= 126) {
            DEFAULT_PLAIN.set(i);
            ++i;
        }
        DEFAULT_PLAIN.clear(37);
        PLAIN_CACHE = new HashMap();
    }

    private Util() {
    }

    public static String getPackage(Class cl) {
        String className = cl.getName();
        int lastDot = className.lastIndexOf(46);
        return className.substring(0, lastDot + 1);
    }

    public static String[] split(String s) {
        return Util.split(s, " \r\f\t\n");
    }

    public static String[] getCsv(String csv) {
        return Util.split(csv, DEFAULT_DELIMITERS);
    }

    public static String[] split(String s, String delim) {
        if (s == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(s, delim);
        String[] result = new String[st.countTokens()];
        int i = 0;
        while (i < result.length) {
            result[i] = st.nextToken();
            ++i;
        }
        return result;
    }

    public static String name(Socket socket) {
        return String.valueOf(socket.getInetAddress().getHostAddress()) + ":" + socket.getPort();
    }

    public static String textEncode(String s) {
        try {
            return Util.textEncodeWithCodeset(s, null, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not create string with default encoding ???", e);
        }
    }

    public static String textEncode(String s, String alsoEncode) {
        try {
            return Util.textEncodeWithCodeset(s, alsoEncode, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not create string with default encoding ???", e);
        }
    }

    public static String textEncodeWithCodeset(String s, String encoding) throws UnsupportedEncodingException {
        return Util.textEncodeWithCodeset(s, null, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String textEncodeWithCodeset(String s, String alsoEncode, String encoding) throws UnsupportedEncodingException {
        int i;
        BitSet plain;
        boolean hack = true;
        if (hack) {
            return s;
        }
        if (alsoEncode == null) {
            plain = DEFAULT_PLAIN;
        } else {
            Pair pair = new Pair(encoding, alsoEncode);
            Map map = PLAIN_CACHE;
            synchronized (map) {
                plain = (BitSet)Util.getSoftMap(PLAIN_CACHE, pair, false);
                if (plain == null) {
                    plain = (BitSet)DEFAULT_PLAIN.clone();
                    byte[] extra = encoding == null ? alsoEncode.getBytes() : alsoEncode.getBytes(encoding);
                    i = 0;
                    while (i < extra.length) {
                        plain.clear(extra[i] & 0xFF);
                        ++i;
                    }
                    Util.putSoftMap(PLAIN_CACHE, pair, plain, false);
                }
            }
        }
        byte[] text = encoding == null ? s.getBytes() : s.getBytes(encoding);
        byte[] output = new byte[text.length * 3];
        int pos = 0;
        i = 0;
        while (i < text.length) {
            int ch = text[i] & 0xFF;
            if (plain.get(ch)) {
                output[pos++] = text[i];
            } else {
                output[pos++] = 37;
                int shift = 4;
                while (shift >= 0) {
                    int nibble = ch >> shift & 0xF;
                    output[pos++] = nibble >= 10 ? (byte)(nibble + 65) : (byte)(nibble + 48);
                    shift -= 4;
                }
            }
            ++i;
        }
        try {
            return new String(output, 0, pos, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not create string with UTF-8 ???", e);
        }
    }

    public static String textDecode(String s) {
        try {
            return Util.textDecodeWithCodeset(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not create string with default encoding ???", e);
        }
    }

    public static String textDecodeWithCodeset(String s, String encoding) throws UnsupportedEncodingException {
        char[] ch = s.toCharArray();
        byte[] decoded = new byte[ch.length];
        int pos = 0;
        int i = 0;
        while (i < ch.length) {
            if (ch[i] == '%' && i + 2 < ch.length) {
                try {
                    int value = Integer.parseInt(s.substring(i + 1, i + 3), 16);
                    decoded[pos++] = (byte)value;
                    i += 2;
                }
                catch (NumberFormatException e) {
                    decoded[pos++] = 37;
                }
            } else {
                decoded[pos++] = (byte)ch[i];
            }
            ++i;
        }
        return encoding == null ? new String(decoded, 0, pos) : new String(decoded, 0, pos, encoding);
    }

    public static Object getSoftMap(Map map, Object key, boolean purge) {
        Object result;
        SoftReference ref = (SoftReference)map.get(key);
        Object v0 = result = ref == null ? null : ref.get();
        if (result == null) {
            map.remove(key);
        }
        if (purge) {
            Iterator it = map.values().iterator();
            while (it.hasNext()) {
                ref = (SoftReference)it.next();
                if (ref != null && ref.get() != null) continue;
                it.remove();
            }
        }
        return result;
    }

    public static Object putSoftMap(Map map, Object key, Object value, boolean purge) {
        Object result = null;
        SoftReference ref = (SoftReference)map.get(key);
        if (ref != null) {
            result = ref.get();
        }
        map.put(key, new SoftReference<Object>(value));
        if (purge) {
            Iterator it = map.values().iterator();
            while (it.hasNext()) {
                ref = (SoftReference)it.next();
                if (ref != null && ref.get() != null) continue;
                it.remove();
            }
        }
        return result;
    }

    public static String getFullPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getPath();
        }
    }

    public static String clean(String rawString) {
        return Util.clean(rawString, 80);
    }

    public static String clean(String rawString, int prefix) {
        int strlen = rawString.length();
        int length = Math.min(strlen, prefix);
        char[] ch = rawString.substring(0, length).toCharArray();
        int i = 0;
        while (i < ch.length) {
            if (ch[i] < ' ' || ch[i] > '~') {
                ch[i] = 63;
            }
            ++i;
        }
        if (length == strlen) {
            return new String(ch);
        }
        StringBuffer sb = new StringBuffer(ch.length + 50);
        sb.append(ch);
        sb.append(" + ");
        sb.append(strlen - length);
        sb.append(" character");
        if (strlen - length != 1) {
            sb.append('s');
        }
        return sb.toString();
    }
}

