#!/bin/sh
# -*- mode: sh; coding: utf-8 -*-
# Test archive creation
# Copyright © 2003 Colin Walters <walters@verbum.org>
#
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.

set -e

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

initial_setup

test_class "Simple Archive creation"

begin_test "Archive creation 1"
tla make-archive jane@example.com--2003 $(pwd)/test-archive
test "$(tla whereis-archive jane@example.com--2003)" = $(pwd)/test-archive
test -d test-archive/=meta-info
end_test 

begin_test "Archive creation 2 (with listing)"
tla make-archive --listing jane@example.com--2003b $(pwd)/test-archive2
test "$(tla whereis-archive jane@example.com--2003b)" = $(pwd)/test-archive2
test -d test-archive2/=meta-info
test -f test-archive2/.listing
end_test 

clean_workdir

# tag: Colin Walters Tue, 16 Sep 2003 22:31:21 -0400 (test-archive-creation.sh)
#
