/*
 * MIDI channel definition
 *
 * Copyright (C) 1996-1998 Takashi Iwai
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef CHANNEL_H_DEF
#define CHANNEL_H_DEF

#ifdef linux
#include <sys/soundcard.h>
#elif defined(__FreeBSD__)
#include <machine/soundcard.h>
#endif

#define MAX_MIDI_CHANNELS	32

typedef struct _ChannelStat {
	int bank, defbank;	/* bank, default bank */
	int preset, defpreset;	/* preset */

	/* parameters */
	int pitchsense;	/* usually 0x100 (= 2 semitones) */
	int pitchbend;	/* 0 - 0x3fff (0x2000 = no bend) */
	int chan_press;	/* channel pressure */
	char controls[127];

	/* tuning */
	int finetune, coarsetune;

	int volscale; 	/* volume sensitivity */
	int bankmode;	/* XG bank mode; bank MSB */
} ChannelStat;

#ifndef CTL_REVERB_DEPTH
#define CTL_REVERB_DEPTH CTL_EXT_EFF_DEPTH
#endif

extern int channel_drums;	/* drum flag bits */
extern ChannelStat channels[MAX_MIDI_CHANNELS];
#define CHAN_ISDRUM(ch)	(channel_drums & DRUMBIT(ch))

#endif	/* CHANNEL_H_DEF */
