/*
 * definition of buffer for OSS sequencer access
 */

#include "vkb.h"
#include <unistd.h>
#include <fcntl.h>
#ifdef __FreeBSD__
#  include <machine/soundcard.h>
#elif defined(linux)
#  include <linux/soundcard.h>
#endif

#define SEQUENCER_DEV	"/dev/sequencer"

int seqfd;
SEQ_DEFINEBUF(128);

void
seqbuf_dump(void)
{
	if (_seqbufptr) {
		if (write(seqfd, _seqbuf, _seqbufptr) == -1) {
			perror("write sequencer");
			exit(1);
		}
	}
	_seqbufptr = 0;
}

int
vkb_open_oss(Tcl_Interp *ip)
{
	char *var;
	char *devfile = SEQUENCER_DEV;
	if ((var = Tcl_GetVar(ip, "devicefile", 0)) != NULL)
		devfile = var;

	if ((seqfd = open(devfile, O_WRONLY, 0)) < 0) {
		vkb_error(ip, "can't open sequencer device '%s'", devfile);
		return -1;
	}
	return 0;
}

