/****************************************************************
**
** Attal : Lords of Doom
**
** ressourceWin.cpp
** show ressources of the player (gold, ...)
**
** Version : $Id: ressourceWin.cpp,v 1.2 2004/07/28 21:07:04 lusum Exp $
**
** Author(s) : Pascal Audoux - Carlo Sardi
**
** Date : 06/09/2000
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "ressourceWin.h"

 
// generic include files
// include files for QT
#include <qlayout.h>
#include <qstring.h>
// application specific includes
#include "libClient/gui.h"
#include "libCommon/dataTheme.h"

extern DataTheme DataTheme;

/** add comments here */
	RessourceWin::RessourceWin( QWidget * parent, const char * name )
:QWidget( parent, name )
{
	_player = 0;
	int k = 1;

	QGridLayout * lay = new QGridLayout( this , DataTheme.resources.count()/2, 2);

	lay->setRowStretch(0,1);
	for( uint i = 0; i < DataTheme.resources.count(); i++ ) {
		_labRessource[i] = new QLabel( this );
		if((i%2) == 0){
			k=i/2+1;
			lay->addWidget( _labRessource[i] , k, 0);
		} else {
			lay->addWidget( _labRessource[i] , k, 1);
		}
	}

	lay->activate();
}

void RessourceWin::setPlayer( GenericPlayer * p )
{
	_player = p;
	reinit();
}

void RessourceWin::reinit()
{
	if( _player != 0 ) {
		QString s;
		
		for( uint i = 0; i < DataTheme.resources.count(); i++ ) {
			s.sprintf( "%s : %d", DataTheme.resources.getRessource( i ).latin1(), _player->getResource( i ) );
			_labRessource[i]->setText( s );
			FIXEDSIZE( _labRessource[i] );
		}
	}
}

